/** @file
  Header file for GpioPrivateLib.
  All function in this library is available for PEI, DXE, and SMM,

@copyright
 Copyright (c) 2019 Intel Corporation. All rights reserved This
 software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _GPIO_PRIVATE_LIB_H_
#define _GPIO_PRIVATE_LIB_H_

#if (CNVI_ENABLE == 1)
#define CNV_CRF_GPIO_COUNT 	6
#define CNV_CRF_GPIO2_COUNT 3
#define GPIO_NEXT_OFFSET 	16
/**
  This function enables and configures CNVi Bluetooth Host wake-up interrupt

  @param[in] None

  @retval Status
**/
EFI_STATUS
GpioConfigureCnviBtHostWakeInt (
  VOID
  );

/**
  This function sets CNVi Bluetooth charging mode

  @param[in] Value                CNVi BT charging mode
                                  0: Normal BT operation
                                  1: BT wireless charging special mode for dead empty battery and S3/4/5 cases
  @retval Status
**/
EFI_STATUS
GpioSetCnviBtChargingMode (
  IN  UINT32  Value
  );
  
/**
  This function sets CNVi Bluetooth Enable value

  @param[in] Value                CNVi BT enable value
                                  0: Disable, 1: Enable
  @retval Status
**/
EFI_STATUS
GpioSetCnviBtEnState (
   IN  UINT32  Value
  );
  
/**
  CNVi Bluetooth UART connection options
**/
typedef enum {
  GpioCnviBtIfUart = 0,
  GpioCnviBtIfUsb,
} VGPIO_CNVI_BT_INTERFACE;

/**
  This function sets CNVi Bluetooth main host interface

  @param[in] BtInterface          CNVi BT Interface Select value
                                  GpioCnviBtIfUart: UART, GpioCnviBtIfUsb: USB
  @retval Status
**/
EFI_STATUS
GpioSetCnviBtInterface (
  IN  VGPIO_CNVI_BT_INTERFACE  BtInterface
  );


/**
  This function sets CNVi GNSS Enable value

  @param[in] Value                CNVi GNSS enable value
                                  0: Disable, 1: Enable
  @retval Status
**/
EFI_STATUS
GpioSetCnviGnssEnState (
  IN  UINT32  Value
  );
  
/**
  CNVi WiFi mode
**/
typedef enum {
    GpioCnviWiFiForcedEnabled,   // WiFi core is forced active
    GpioCnviWiFiHostaccessable   // WiFi Core D0/D3 state through Host accessible state
} VGPIO_CNVI_WIFI_MODE;

/**
  This function sets CNVi WiFi mode

  @param[in] Value                CNVi WiFi Mode value
                                  GpioCnviWiFiHostaccessable: WiFi uses Host accessible registers for WiFi Power state transitions
                                  GpioCnviWiFiForcedEnabled: WiFi uses normal Flow for WiFi Power state transitions
  @retval Status
**/
EFI_STATUS
GpioSetWifiHostAccessMode (
  IN  VGPIO_CNVI_WIFI_MODE  WiFiMode
  );

/**
  This function configures GPIO connection between CNVi and CRF

  @retval Status
**/
EFI_STATUS
GpioConfigureCnviCrfConnection (
  BOOLEAN ConditionalCfg
  );

#endif

/**
  This function indicates the SoC eSPI mode

  @param[out] eSpiMode            eSPI Flash Sharing Mode:
                                  	  1=slave attached flash sharing (SAFS);
                                  	  0=master attached flash sharing (MAFS; default)

  @retval boolean 				  TRUE: if eSPI mode is enabled
  	  	  	  	  	  	  	  	  FALSE: if LPC mode is enabled
**/
BOOLEAN
Is_eSPI_Mode (
  OUT   UINT8   *eSpiMode
);

/**
  This function indicates whether the SoC supports the integrated CNV or not

  @retval boolean                 TRUE: if CNVi is enabled,
                                  FALSE: if SoC does not support CNVi
**/
BOOLEAN
Is_SoC_integrated_Connectivity_Supported(
);
#endif // _GPIO_PRIVATE_LIB_H_
