/** @file
  Header file for PchPcrLib.

@copyright
 Copyright (c) 2016 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _SC_CNVI_LIB_H_
#define _SC_CNVI_LIB_H_

#if (CNVI_ENABLE == 1)
#include <Ppi/ScPolicy.h>

/**
  Performs Global Reset required to change CNVi static power gating state.
**/
STATIC
VOID
CnviPerformGlobalReset (
  VOID
  );

/**
  Disable CNVi
**/
VOID
ScDisableCnvi (
  UINT32    *FuncDisable1Reg  
  );

/**
  Configure CNVi BT
**/
VOID
ScCnviConfigureBt (
  IN SC_CNVI_CONFIG    *CnviConfig
  );

/**
  Configure Sx Wake state
 **/
VOID
ConfigureSxWake(
		IN  SC_POLICY_PPI     *ScPolicyPpi,
		UINT32
		);

BOOLEAN
ScCnviLTREnbale(
  VOID
  );
 
    
#endif

#endif // _SC_CNVI_LIB_H_
