/** @file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef __EFI_WATCHDOG_TIMER_DRIVER_PROTOCOL_H__
#define __EFI_WATCHDOG_TIMER_DRIVER_PROTOCOL_H__

#define EFI_WATCHDOG_TIMER_DRIVER_PROTOCOL_GUID \
  { 0xd5b06d16, 0x2ea1, 0x4def, 0x98, 0xd0, 0xa0, 0x5d, 0x40, 0x72, 0x84, 0x17 }

#define EFI_WATCHDOG_TIMER_NOT_SUPPORTED_PROTOCOL_GUID \
  { 0xe9e156ac, 0x3203, 0x4572, 0xac, 0xdf, 0x84, 0x4f, 0xdc, 0xdb, 0x6, 0xbf }


#include <Guid/HwWatchdogTimerHob.h>

//
// General Purpose Constants
//
#define ICH_INSTAFLUSH_GPIO      BIT16 // BIT 16 in GPIO Level 2 is GPIO 48.
#define B_INSTAFLUSH             BIT4
//
// Other Watchdog timer values
//
#define WDT_COUNTDOWN_VALUE                 0x14
#define BDS_WDT_COUNTDOWN_VALUE             0x35


//
// Prototypes for the Watchdog Timer Driver Protocol
//

/**
    This service begins the Watchdog Timer countdown.  If the countdown completes prior to
    Stop Timer or Restart Timer the system will reset.

    @param[in]  None

    @retval  EFI_SUCCESS       Operation completed successfully
    @retval  EFI_DEVICE_ERROR  The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_START_TIMER) (
  VOID
  );



/**
    This service resets the Watchdog Timer countdown and should only be called after the
    Start Timer function.

    @param[in]  None

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *PEI_WATCHDOG_RESET_TIMER) (
  VOID
  );



/**
    This service restarts the Watchdog Timer countdown and should only be called after the
    Start Timer function.

    @param[in]  None

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_RESTART_TIMER) (
  VOID
  );


/**
    This service disables the Watchdog Timer countdown.

    @param[in]  None

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_STOP_TIMER) (
  VOID
  );


/**
    This service disables the Watchdog Timer countdown.

    @param[out]  WatchdogTimeout

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_CHECK_TIMEOUT) (
  OUT HW_WATCHDOG_TIMEOUT       *WatchdogTimeout
  );



/**
    This service forces a reboot of the system due to a reset of the POWERGOOD_PS,
    POWERGOOD_CLK, and the BSEL Override

    @param[in]  ForceTimeout
    @param[in]  ResetType

    @retval  EFI_DEVICE_ERROR   The command was unsuccessful and a reboot did not occur
    
	This function should not return!
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_FORCE_REBOOT) (
  IN BOOLEAN                    ForceTimeout,
  IN UINT8                      ResetType
  );


/**
    This service notifies the Watchdog Timer of the fact that a known reset is occuring.

    @param[in]  AllowReset   TRUE if a Reset is currently expected
                             FALSE if a Reset is not currently expected

    @retval  EFI_DEVICE_ERROR  The command was unsuccessful and a reboot did not occur
    
	This function should not return!
**/
typedef
EFI_STATUS
(EFIAPI *EFI_WATCHDOG_KNOWN_RESET) (
  IN BOOLEAN                    AllowReset
  );

/**
    This service reads the current Watchdog Timer countdown reload value.

    @param[in]  CountdownValue  pointer to UINT32 to return the value of the reload register.

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_GET_TIMER_COUNT_DOWN_PERIOD)(
  OUT UINT32      *CountdownValue
  );

/**
    This service reads the current Watchdog Timer countdown reload value.

    @param[out]      CountdownValue   Value to set the reload register.

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_SET_TIMER_COUNT_DOWN_PERIOD)(
  OUT UINT32      CountdownValue
  );

/**
    This service clears the state that indicates the Watchdog Timer fired.

    @param[in]      None

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *PEI_WATCHDOG_CLEAR_TIMER_STATE) (
  );

/**
    This service disables the Watchdog Timer countdown.  It also closes the recurring restart event
    if the event exists.

    @param[in]  Stall   TRUE = Stop the timer countdown, FALSE = Start the timer countdown

    @retval  EFI_SUCCESS        Operation completed successfully
    @retval  EFI_DEVICE_ERROR   The command was unsuccessful
**/
typedef
EFI_STATUS
(EFIAPI *EFI_STALL_WATCHDOG_COUNTDOWN) (
  IN BOOLEAN Stall
  );

/**
  This protocol allow a platform module to perform watch dog timer operations.
**/
typedef struct _EFI_WATCHDOG_TIMER_DRIVER_PROTOCOL {
  EFI_WATCHDOG_START_TIMER                      StartWatchdogTimer;
  PEI_WATCHDOG_RESET_TIMER                      ResetWatchdogTimeout;
  EFI_WATCHDOG_RESTART_TIMER                    RestartWatchdogTimer;
  EFI_WATCHDOG_STOP_TIMER                       StopWatchdogTimer;
  EFI_WATCHDOG_CHECK_TIMEOUT                    CheckWatchdogTimeout;
  EFI_WATCHDOG_FORCE_REBOOT                     ForceReboot;
  EFI_WATCHDOG_KNOWN_RESET                      AllowKnownReset;
  EFI_GET_TIMER_COUNT_DOWN_PERIOD               GetCountdownPeriod;
  EFI_SET_TIMER_COUNT_DOWN_PERIOD               SetCountdownPeriod;
  PEI_WATCHDOG_CLEAR_TIMER_STATE                ClearTimerState;
  EFI_STALL_WATCHDOG_COUNTDOWN                  StallWatchdogCountdown;
} EFI_WATCHDOG_TIMER_DRIVER_PROTOCOL;

extern EFI_GUID gEfiWatchdogTimerDriverProtocolGuid;
extern EFI_GUID gEfiWatchdogTimerNotSupportedProtocolGuid;

#endif
