/** @file
  Register names for CNVi

  Conventions:

  - Prefixes:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    Definitions beginning with "V_" are meaningful values within the bits
    Definitions beginning with "S_" are register sizes
    Definitions beginning with "N_" are the bit position
  - In general, PCH registers are denoted by "_PCH_" in register names
  - Registers / bits that are different between PCH generations are denoted by
    "_PCH_[generation_name]_" in register/bit names.
  - Registers / bits that are specific to PCH-H denoted by "_H_" in register/bit names.
    Registers / bits that are specific to PCH-LP denoted by "_LP_" in register/bit names.
    e.g., "_PCH_H_", "_PCH_LP_"
    Registers / bits names without _H_ or _LP_ apply for both H and LP.
  - Registers / bits that are different between SKUs are denoted by "_[SKU_name]"
    at the end of the register/bit names
  - Registers / bits of new devices introduced in a PCH generation will be just named
    as "_PCH_" without [generation_name] inserted.

@copyright
 Copyright (c) 2017 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _PCH_REGS_CNVI_H_
#define _PCH_REGS_CNVI_H_

#if (CNVI_ENABLE == 1)
//
//  CNVi WiFi Registers (D12:F0)
//
#define PCI_DEVICE_NUMBER_PCH_CNVI_WIFI     12
#define PCI_FUNCTION_NUMBER_PCH_CNVI_WIFI   0
#define V_PCH_CNVI_CFG_WIFI_VENDOR_ID           V_PCH_INTEL_VENDOR_ID

//
// Private registers description for CNVi WiFi
//
#define R_SC_CNVI_PCR_WIFI_WIDGET_CONTROL           0x8114  ///< Widget Control
#define R_SC_CNVI_PCR_WIFI_WIDGET_CONTROL_MEM_INT   0xFF    ///< IRQ number

//
// CNVi WiFi MMIO register definitions
//
#define	R_SC_CNVI_MEM_WIFI_RESET_CSR_AD                 0x20
#define B_SC_CNVI_MEM_WIFI_CNT_RST_REQ									BIT7

#define	R_SC_CNVI_WIFI_HOST_CHICKEN_CSR_AD               0x204
#define B_SC_CNVI_WIFI_PM_IDLE_SRC_DIS_SB_PME			BIT19


#define	R_SC_CNVI_MEM_WIFI_GP_CTRL_CSR_AD               0x24
#define B_SC_CNVI_MEM_WIFI_HS_MAC_ACC_REQ					 			BIT3
#define B_SC_CNVI_MEM_WIFI_INIT_DONE						   			BIT2
#define B_SC_CNVI_MEM_WIFI_MAC_CLK_RDY_0								BIT0

#define R_SC_CNVI_MEM_WIFI_RF_ID_VAL                       0x9C          //RF Chip ID Value 
#define B_SC_CNVI_MEM_WIFI_RF_ID_VAL_B_STEP                0x1			 //A Step 0, B-Step 1
#define B_SC_CNVI_MEM_WIFI_RF_ID_VAL_PRODUCT_TYPE          0x105         //For ES1/ES2/ES3 Product Type



#define	A_SC_CNVI_MEM_WIFI_HPM_HIPM_GEN_CFG							0x03458		//register address declaration (only 20 bits

#define	R_SC_CNVI_MEM_WIFI_HBUS_TARG_PRPH_RADDR    			0x448

#define	R_SC_CNVI_MEM_WIFI_HBUS_TARG_PRPH_WADDR    			0x444

#define	V_SC_CNVI_MEM_WIFI_HBUS_HPBR_ADDR								0xFFFFF
#define	N_SC_CNVI_MEM_WIFI_HBUS_HPBR_ADDR								0
#define	V_SC_CNVI_MEM_WIFI_HBUS_HPBR_SIZE								(BIT25 | BIT24)
#define	N_SC_CNVI_MEM_WIFI_HBUS_HPBR_SIZE								24

#define	R_SC_CNVI_MEM_WIFI_HBUS_TARG_PRPH_RDAT        	0x450

#define	R_SC_CNVI_MEM_WIFI_HBUS_TARG_PRPH_WDAT       		0x44C

#define R_SC_CNVI_MEM_WIFI_HOST_CHICKEN_CSR_AD				 	0x204
#define B_SC_CNVI_MEM_WIFI_PM_IDLE_SRC_DIS_SB_PME			 	BIT19

#define R_SC_PCI_CNVI_GIO_DEV_2 0x68
#define R_SC_PCI_CNVI_GIO_DEV 0x64
#define B_SC_PCI_CNVI_LTR_MEC_SUP 0x800
#define B_SC_PCI_CNVI_LTR_MEC_ENB 0x400


#endif

#endif

