/** @file
  BXT-P Bx HSIO C File

@copyright
 Copyright (c) 2018 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#include <Uefi/UefiBaseType.h>
#include <ScAccess.h>
#include <Private/ScHsio.h>
#include <Private/ScGelkHsioAx.h>

UINT16 ScGelkUsb3HsioAddress[6] = {
  0x2000,
  0x2200,
  0x2400,
  0x2600,
  0xE00,
  0xA00
};

UINT16 ScGelkPcieHsioAddress[6] = {
  0x800,
  0x200,
  0x0,
  0xE00,
  0x2600,
  0x2400
};

UINT16 ScGelkSataHsioAddress[2] = {
  0xC00,
  0xA00,
};


SC_SBI_HSIO_TABLE_STRUCT ScGelkHsioTable_Ax[] = {
   {0xA5, 0xDFFFFFFF, 0x20000000, 0x8020, SC_LANE_OWN_COMMON},         // LANE
   {0xB1, 0xDFFFFFFF, 0x20000000, 0x8020, SC_LANE_OWN_COMMON},         // LANE
   {0xA5, 0xFFFFFF00,       0x40, 0x8034, SC_LANE_OWN_COMMON},         // LANE
   {0xB1, 0xFFFFFF00,       0x40, 0x8034, SC_LANE_OWN_COMMON},         // LANE
   {0xA5, 0xFFFFFF00,       0x17, 0x8008, SC_LANE_OWN_COMMON},         // LANE
   {0xB1, 0xFFFFFF00,       0x17, 0x8008, SC_LANE_OWN_COMMON},         // LANE
   {0xA5, 0xFFF0FFFF,   0x2F0000, 0x8000, SC_LANE_OWN_COMMON},         // LANE
   {0xA5, 0xFFE0E0E0,    0xC0C0F,   0x24, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFDFFF,        0x0,   0x28, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFDFF00FF,  0x2001700,   0x04, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFF00FF,     0x1700,   0x04, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFBFF00FF,  0x4001700,   0x04, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFF80,        0x4,   0x20, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFFFFF0,        0xD,   0x20, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFFF0,        0xD,   0x20, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFF8FFFF,    0x20000,   0x18, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFFFEFF,      0x100,   0x10, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0x1FFFFFFF,        0x0,   0x1C, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0x1FFFFFFF,        0x0,   0x1C, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0x1FFFFFFF,        0x0,   0x1C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0x000000FF, 0xE0163500,   0x64, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF03FFFF,   0x7C0000,   0x3C, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFF03FFFF,   0x7C0000,   0x3C, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFF03FFFF,   0x7C0000,   0x3C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF0000FF,   0x3F5100,   0x90, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFF0000FF,   0x3F5100,   0x90, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFF000000,   0x3F406F,   0x90, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFDFF,      0x200,   0xB8, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFF7F,       0x80,   0xAC, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xBFFFFFFF, 0x40000000,   0x94, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF00FFFF,   0x690000,   0x8C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFF0000,     0xC710,  0x140, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFF000000,   0x12C510,  0x140, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFF000000,   0x12C50A,  0x140, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF000000,    0x8CB0A,  0x144, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF000000,    0x4CB0C,  0x148, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0x87FFFFFF,  0x8000000,  0x114, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xE1FFFFF8, 0x1E000007,  0x1CC, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xE1FF80F8, 0x1E001A03,  0x1CC, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xE1FF80F8, 0x1E001A07,  0x1CC, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xF2FFFFF0,  0xD00000F,  0x168, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFEFFF7FF,  0x1000800,  0x168, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xC0FFC0FF, 0x10000100,  0x16C, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xC0C0C0FF,  0x8283F00,  0x16C, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xC0C0C0FF, 0x10000700,  0x16C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFDFC0FF,   0x203F00,  0x178, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFDFC018,   0x2039C6,  0x178, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFDFC018,   0x2037C6,  0x178, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFF0F0,      0x607,  0x110, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0x00FFFFFF, 0x84000000,  0x110, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFF000,      0x6C7,  0x110, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xF0FFFFFF,  0x7000000,  0x10C, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFF0000,     0xB7C7,  0x118, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFE3FFFF,    0x80000,  0x124, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFF0000,     0x6D10,  0x1AC, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFF0000,     0x4109,  0x1AC, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF80FFFF,    0x70000,  0x17C, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFF80FFFF,    0x40000,  0x17C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xC0C0FFFF, 0x3C020000,  0x158, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xC0C0FFFF, 0x3C040000,  0x158, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFEFF0000,  0x1001250,  0x104, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFE000000,  0x14A1610,  0x104, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFFDF,       0x20,  0x13C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xC0FFFFFF, 0x27000000,  0x150, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFC0FFFF,   0x200000,  0x154, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xC0FFFFC0, 0x20000020,  0x154, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFFDF,       0x20,  0x108, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFFFFDF,       0x20,  0x108, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFFDF,       0x20,  0x108, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0x80FFFFFF, 0x25000000,  0x18C, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0x80FFFFFF, 0x25000000,  0x18C, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0x80FFFFFF, 0x25000000,  0x18C, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFFFF80,       0x22,  0x190, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFFFF80,       0x22,  0x190, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFF80,       0x22,  0x190, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFF81FFFF,   0x6C0000,  0x184, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFFF9,        0x2,  0x170, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFFBF,        0x0,   0x04, V_SC_FIA_PCR_LANE_OWN_PCIE}, // UNICAST
   {0xA5, 0xFFFFFFBF,        0x0,   0x04, V_SC_FIA_PCR_LANE_OWN_USB3}, // UNICAST
   {0xA5, 0xFFFFFFBF,        0x0,   0x04, V_SC_FIA_PCR_LANE_OWN_SATA}, // UNICAST
   {0xA5, 0xFFFF00FF,     0x4000, 0x8034, SC_LANE_OWN_COMMON},         // LANE
   {0xB1, 0xFFFF00FF,     0x4000, 0x8034, SC_LANE_OWN_COMMON},         // LANE
};
