
/** @file
 SC Smi Dispatch and  Record Insert for eSPI SMi.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#include "ScSmmHelpers.h"

#define SC_SMM_ADDR_TYPE_NULL -1



VOID
EFIAPI
NullInitSourceDesc (
   SC_SMM_SOURCE_DESC                   *SrcDesc
   )
{
  ZeroMem (SrcDesc, sizeof (SC_SMM_SOURCE_DESC));
  SrcDesc->En[0].Reg.Type = SC_SMM_ADDR_TYPE_NULL;
  SrcDesc->En[1].Reg.Type = SC_SMM_ADDR_TYPE_NULL;
  SrcDesc->Sts[0].Reg.Type = SC_SMM_ADDR_TYPE_NULL;
//  SrcDesc->PmcSmiSts.Reg.Type = PCH_SMM_ADDR_TYPE_NULL;
}


EFI_STATUS
ScSmiRecordInsert (
  IN  SC_SMM_SOURCE_DESC               *SrcDesc,
  IN  SC_SMI_CALLBACK_FUNCTIONS        DispatchFunction,
  IN  EFI_SMM_ICHN_SMI_TYPE                     ScSmiType,
  OUT EFI_HANDLE                        *DispatchHandle
  )
{
  EFI_STATUS                            Status;
  DATABASE_RECORD                       Record;

  if (SrcDesc == NULL) {
    return EFI_INVALID_PARAMETER;
  }

  ZeroMem (&Record, sizeof (DATABASE_RECORD));
  //
  // Gather information about the registration request
  //
  Record.Signature                      = DATABASE_RECORD_SIGNATURE;
  Record.ScSmiCallback                 = DispatchFunction;
  Record.ProtocolType                   = ScSmiDispatchType;
  Record.ScSmiType                     = ScSmiType;


  CopyMem (&Record.SrcDesc, SrcDesc, sizeof (SC_SMM_SOURCE_DESC));

  Status = SmmCoreInsertRecord (
             &Record,
             DispatchHandle
             );
  ASSERT_EFI_ERROR (Status);

  return EFI_SUCCESS;
}


/**
  The function to dispatch all callback function for Espi SMI types.

  @retval EFI_SUCCESS                   Function successfully completed
  @retval EFI_UNSUPPORTED               no
**/
EFI_STATUS
ScSmiTypeCallbackDispatcher (
  IN  DATABASE_RECORD                   *Record
  )
{
  EFI_STATUS                            Status;
  EFI_SMM_ICHN_SMI_TYPE                 ScSmiType;


  ScSmiType = Record->ScSmiType;
  Status     = EFI_SUCCESS;

  switch (ScSmiType) {
   
    case IchnEspiSmi:
      ((SC_ESPI_SMI_DISPATCH_CALLBACK) (Record->ScSmiCallback)) ((EFI_HANDLE)&Record->Link);
      break;
    
   
    default:
      Status = EFI_UNSUPPORTED;
      break;
  }

  return Status;
}
