/** @file
  Implements HECI Runtime Services

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _HECI_RUNTIME_DXE_H_
#define _HECI_RUNTIME_DXE_H_

#include <Library/UefiLib.h>
#include <Library/UefiDriverEntryPoint.h>
#include <Library/DebugLib.h>
#include <Library/UefiRuntimeLib.h>
#include <Library/DxeServicesTableLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Protocol/Heci.h>
#include <SeCAccess.h>
#include <HeciRegs.h>
#include <Library/MmPciLib.h>
#include <Library/TimerLib.h>
#include <Library/HeciMsgLib.h>
#include <Library/PcdLib.h>


/**
  Send Heci message with response

  @param[in]      HeciDev       HECI device
  @param[in,out]  Message       Message Data
  @param[in,out]  Length        Message Data Length
  @param[in,out]  RecLength     Return message buffer length
  @param[in]      HostAddress   Host Address
  @param[in]      SECAddress    CSE Address

  @retval  EFI_SUCCESS          Send message success.
  @retval  Others               Send message failed.
**/
EFI_STATUS
EFIAPI
EfiHeciSendwack (
  IN      HECI_DEVICE  HeciDev,
  IN OUT  UINT32       *Message,
  IN OUT  UINT32       Length,
  IN OUT  UINT32       *RecLength,
  IN      UINT8        HostAddress,
  IN      UINT8        SeCAddress
  );

/**
  Read the Heci message

  @param[in]      HeciDev      HECI Device ID.
  @param[in]      Blocking      Indicate does waiting for response.
  @param[in]      MessageBody Message data buffer.
  @param[in,out]  Length          Message data buffer size.

  @retval  EFI_SUCCESS   Send message success.
  @retval  Others              Send message failed.
**/
EFI_STATUS
EFIAPI
EfiHeciReadMessage(
  IN      HECI_DEVICE      HeciDev,
  IN      UINT32           Blocking,
  IN      UINT32           *MessageBody,
  IN OUT  UINT32           *Length
  );

/**
  Send Heci message without response

  @param[in]  HeciDev      HECI Device ID.
  @param[in]  Message      Message Data.
  @param[in]  Length       Message Data length.
  @param[in]  HostAddress  Host Address.
  @param[in]  SECAddress   CSE Address.

  @retval  EFI_SUCCESS     Send message success.
  @retval  Others          Send message failed.
**/
EFI_STATUS
EFIAPI
EfiHeciSendMessage(
  IN      HECI_DEVICE      HeciDev,
  IN      UINT32           *Message,
  IN      UINT32           Length,
  IN      UINT8            HostAddress,
  IN      UINT8            SeCAddress
  );

/**
  Reset the HECI device.

  @param[in]   HeciDev  HECI Device ID.

  @retval  EFI_SUCCESS  Reset HECI success.
  @retval  Others       Reset HECI failed.
**/
EFI_STATUS
EFIAPI
EfiHeciReset(
  IN      HECI_DEVICE      HeciDev
  );

/**
  Init the HECI device

  @param[in]   HeciDev   HECI Device ID.

  @retval  EFI_SUCCESS   Init HECI success.
  @retval  Others        Init HECI failed.
**/
EFI_STATUS
EFIAPI
EfiHeciInit(
  IN      HECI_DEVICE      HeciDev
  );

/**
  Reinit the HECI device

  @param[in]            HeciDev HECI Device ID.

  @retval  EFI_SUCCESS  HECI reinitialized successfully
  @retval  Others       HECI failed to reinitialize successfully
**/
EFI_STATUS
EFIAPI
EfiHeciReinit (
  IN      HECI_DEVICE      HeciDev
  );

/**
  Reset the HECI device and waiting for Delay time

  @param[in]      HeciDev   HECI Device ID.
  @param[in]      Delay     The time waiting for reset.

  @retval  EFI_SUCCESS      Reset success.
  @retval  Others           Reset failed.
**/
EFI_STATUS
EFIAPI
EfiHeciResetWait (
  IN      HECI_DEVICE      HeciDev,
  IN      UINT32           Delay
  );

/**
  Get the HECI status

  @param[out]  Status    HECI Staus.

  @retval  EFI_SUCCESS   Get status success.
  @retval  Others        Get status failed.
**/
EFI_STATUS
EFIAPI
  EfiHeciGetSecStatus (
  OUT UINT32               *Status2
  );

/**
  Get the HECI mode

  @param[in]     HeciDev  HECI Device ID.
  @param[out]    Mode     Heci Mode

  @retval  EFI_SUCCESS    Get mode success.
  @retval  Others         Get mode failed.
**/
EFI_STATUS
EFIAPI
EfiHeciGetSecMode(
  IN  HECI_DEVICE                 HeciDev,
  OUT  UINT32                     *Mode
  );

#endif
