/** @file
  Header file that defines common MBP structures

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#ifndef _MBP_DEF_H_
#define _MBP_DEF_H_

#include <MkhiMsgs.h>

#define MAX_MBP_ITEM_COUNT               0x100
#define MAX_MBP_ITEM_TOTAL_SIZE          (sizeof (UINT32) * (MAX_MBP_ITEM_COUNT))
#define HEADER_LENGTH                    0x2

//
// Defining MBP APP Ids
//
#define MBP_APP_ID_KERNEL       1
#define MBP_APP_ID_DNX          7
#define MBP_APP_ID_NVM          8

//
// Defining MBP Item Ids
//
#define MBP_ITEM_IAFW_DNX_REQ             1
#define MBP_ITEM_ID_SMM_TRUSTED_CHANNEL   2
#define MBP_ITEM_ID_BIOS_PLATFORM_KEY     4


typedef enum {
  BOOT_FROM_EMMC  = 0,
  BOOT_FROM_UFS   = 1,
  BOOT_FROM_SPI   = 2
} BOOT_MEDIA;

#pragma pack(push, 1)

typedef union _MEFWCAPS_SKU {
  UINT32  Data;
  struct {
    UINT32  FullNet : 1;              ///< [0] Full network manageability
    UINT32  StdNet : 1;               ///< [1] Standard network manageability
    UINT32  Manageability : 1;        ///< [2] Manageability
    UINT32  SmallBusiness : 1;        ///< [3] Small business technology
    UINT32  IntegratedTouch : 1;      ///< [4] Intel Integrated Touch
    UINT32  IntelAT : 1;              ///< [5] IntelR Anti-Theft (AT)
    UINT32  IntelCLS : 1;             ///< [6] IntelR Capability Licensing Service (CLS)
    UINT32  Reserved3 : 3;            ///< [9:7] Reserved
    UINT32  IntelMPC : 1;             ///< [10] IntelR Power Sharing Technology (MPC)
    UINT32  IccOverClocking : 1;      ///< [11] ICC Over Clocking
    UINT32  PAVP : 1;                 ///< [12] Protected Audio Video Path (PAVP)
    UINT32  NFF : 1;                  ///< [13] NFF
    UINT32  Reserved4 : 3;            ///< [16:14] Reserved
    UINT32  IPV6 : 1;                 ///< [17] IPV6
    UINT32  KVM : 1;                  ///< [18] KVM Remote Control (KVM)
    UINT32  OCH : 1;                  ///< [19] Outbreak Containment Heuristic (OCH)
    UINT32  VLAN : 1;                 ///< [20] Virtual LAN (VLAN)
    UINT32  TLS : 1;                  ///< [21] TLS
    UINT32  Reserved5 : 1;            ///< [22] Reserved
    UINT32  WLAN : 1;                 ///< [23] Wireless LAN (WLAN)
    UINT32  Reserved6 : 5;            ///< [28:24] Reserved
    UINT32  PTT : 1;                  ///< [29] Platform Trust Technoogy (PTT)
    UINT32  Reserved7 : 1;            ///< [30] Reserved
    UINT32  NFC : 1;                  ///< [31] NFC
  } Fields;
} MEFWCAPS_SKU;

typedef struct _MBP_CMD_REQ_DATA
{
  MKHI_MESSAGE_HEADER  MKHIHeader;
  UINT32               Flag;
} MBP_CMD_REQ_DATA;

typedef struct _MBP_CMD_RESP_DATA
{
  MKHI_MESSAGE_HEADER  MKHIHeader;
  UINT8                Length;
  UINT8                ItemsNum;
  UINT8                Flags;
  UINT8                Reserved;
} MBP_CMD_RESP_DATA;

typedef struct _MBP_ITEM_HEADER
{
  UINT8        AppID;
  UINT8        ItemID;
  UINT8        Length;
  UINT8        Flag;
} MBP_ITEM_HEADER;

typedef struct _MBP_CURRENT_BOOT_MEDIA
{
  UINT32      BPDTOffset;
  UINT32      PhysicalData;
  UINT32      PhysicalDeviceArea;
  UINT32      LogicalData;
} MBP_CURRENT_BOOT_MEDIA;

typedef struct _MBP_IFWI_DNX_REQUEST
{
  UINT32      MbpItemHeader;
  UINT32      EnterRecovery;
} MBP_IFWI_DNX_REQUEST;

typedef struct _MBP_NFC_DEVICE_TYPE
{
  UINT32      MbpItemHeader;
  UINT32      NfcDeviceData;
} MBP_NFC_DEVICE_TYPE;

typedef struct _MBP_ME_FW_CAPS
{
  UINT32          MbpItemHeader;
  MEFWCAPS_SKU    CurrentFeatures;
} MBP_ME_FW_CAPS;

#pragma pack(pop)

#endif
