/** @file
  Header file for HECI Trusted Channnel definitions

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference

**/

#ifndef _TRUSTED_CHANNEL_H_
#define _TRUSTED_CHANNEL_H_

#include <Uefi.h>

#define HECI2_HMAC_SHA256_SIGNATURE_SIZE  32

#define TRUSTED_CHANNEL_HEADER_ALIGNMENT  4
#define TRUSTED_CHANNEL_GET_PAD_SIZE(a) (((~a) + 1) & (TRUSTED_CHANNEL_HEADER_ALIGNMENT - 1))

#pragma pack(push, 1)

typedef struct _MBP_SMM_TRUSTED_KEY
{
  UINT8       SmmTrustedKey[32];
  UINT32      MonotonicCounter;
} MBP_SMM_TRUSTED_KEY;

typedef struct _HECI2_TRUSTED_CHANNEL_BIOS_HEADER {
  UINT8  Signature[HECI2_HMAC_SHA256_SIGNATURE_SIZE];  ///< HMAC-SHA2 of the message
                                                       ///< Note: This signature is not part of the hash
  UINT8  RequestResponse : 1;                          ///< Request = 0, Response = 1
  UINT8  CommandId       : 7;                          ///< Command ID (XXX_CMD_ID)
  UINT32 MonotonicCounter;                             ///< Counter value of the request
                                                       ///< This counter is incremented for each request
} HECI2_TRUSTED_CHANNEL_BIOS_HEADER;

#pragma pack(pop)

#endif
