/** @file
  Implementation file for the HECI2 Null Message Library

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference

**/

#include <Uefi.h>

#include <Library/BaseLib.h>
#include <Library/Heci2MsgLib.h>

/**
  Get the HECI2 read buffer size.

  @param       None

  @retval      UINTN   The HECI2 read buffer size in bytes.
**/
UINTN
EFIAPI
HeciGetHeci2ReadBufferSize (
  VOID
  )
{
  return MAX_HECI2_READ_DATA_SIZE;
}

/**
  Get the HECI2 write buffer size.

  @param       None

  @retval      UINTN   The HECI2 write buffer size in bytes.
**/
UINTN
EFIAPI
HeciGetHeci2WriteBufferSize (
  VOID
  )
{
  return MAX_HECI2_WRITE_DATA_SIZE;
}

/**
  Get NVM file's size through HECI2.

  @param[in]  FileName       The file name.
  @param[out] FileSize       The file's size.
  @param[in]  Heci2Protocol  A pointer to a HECI2 protocol instance.

  @return     EFI_SUCCESS    Get NVM file size success.
  @return     Others         Get NVM file size failed.
**/
EFI_STATUS
Heci2GetNVMFileSize (
  IN  CONST  UINT8              *FileName,
  OUT        UINTN              *FileSize,
  IN  CONST  EFI_HECI_PROTOCOL  *Heci2Protocol
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Populate the CSE variable storage command queue with HMAC CSE NVM read commands.

  @param[in]     FileName              The file name.
  @param[in]     Offset                The offset of data.
  @param[in]     DataSize              The data size in bytes.
  @param[in,out] CommandQueueBuffer    A pointer to a buffer of EFI_CIRCULAR_BUFFER that holds the command queue

  @return        EFI_SUCCESS           The command queue was populated successfully.
  @return        Others                The command queue could not be populated successfully.
**/
EFI_STATUS
EFIAPI
PopulateCseReadFileCommandQueue (
  IN     CONST  UINT8                *FileName,
  IN            UINT32               Offset,
  IN            UINTN                DataSize,
  IN OUT        EFI_CIRCULAR_BUFFER  *CommandQueueBuffer
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Populate the CSE variable storage command queue with HMAC CSE NVM write commands.

  @param[in]     FileName              The file name.
  @param[in]     Offset                The offset of data in the file.
  @param[in]     Data                  The data buffer.
  @param[in]     DataSize              The data size in bytes.
  @param[in]     Truncate              Indicates if the file should be truncated.
  @param[in,out] CommandQueueBuffer    A pointer to a buffer of EFI_CIRCULAR_BUFFER that holds the command queue

  @return        EFI_SUCCESS           The command queue was populated successfully.
  @return        Others                The command queue could not be populated successfully.
**/
EFI_STATUS
EFIAPI
PopulateCseWriteFileCommandQueue (
  IN      CONST CHAR8                *FileName,
  IN            UINT32               Offset,
  IN      CONST UINT8                *Data,
  IN            UINTN                DataSize,
  IN            BOOLEAN              Truncate,
  IN OUT        EFI_CIRCULAR_BUFFER  *CommandQueueBuffer
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Lock Directory message through HECI2.

  TODO: This needs to be updated to use HECI2_TRUSTED_CHANNEL

  @param[in] DirName       The Directory name.
  @param[in] Heci2Protocol The HECI protocol to send the message to HECI2 device.

  @return EFI_SUCCESS   Send EOP message success.
  @return Others              Send EOP message failed.
**/
EFI_STATUS
Heci2LockDirectory (
  IN UINT8               *DirName,
  IN EFI_HECI_PROTOCOL   *Heci2Protocol
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Returns a signed HECI Trusted Channel Get Proxy State message header.

  @param[out] MessageRequestHeader  A pointer the buffer that contains the Get Proxy State header.

  @return     EFI_SUCCESS      Constructed and signed the Get Proxy State message header successfully.
  @return     Others           Failed to construct and sign the Get Proxy State message header.
**/
EFI_STATUS
Heci2GetProxyStateMessageHeader (
  OUT  HECI2_TRUSTED_CHANNEL_BIOS_HEADER  *TrustedChannelHeader
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Write data to NVM file through HECI2.

  @param[in] FileName          The file name.
  @param[in] Offset            The offset of data.
  @param[in] Data              The data content.
  @param[in] DataSize          Data's size.
  @param[in] Truncate          Truncate the file.
  @param[in] Heci2Protocol     A pointer to a valid instance of the EFI_HECI_PROTOCOL

  @return EFI_SUCCESS   Write NVM file success.
  @return Others        Write NVM file failed.
**/
EFI_STATUS
Heci2WriteNVMFile (
  IN CONST CHAR8              *FileName,
  IN       UINT32             Offset,
  IN CONST UINT8              *Data,
  IN       UINTN              DataSize,
  IN       BOOLEAN            Truncate,
  IN CONST EFI_HECI_PROTOCOL  *Heci2Protocol
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}

/**
  Read NVM file data through HECI2.

  @param[in]     FileName       The file name.
  @param[in]     Offset         The offset of data.
  @param[out]    Data           The data buffer.
  @param[in,out] DataSize       Data's size.
  @param[in]     Heci2Protocol  Pointer to a valid instance of the EFI_HECI_PROTOCOL

  @return        EFI_SUCCESS    Read NVM file success.
  @return        Others         Read NVM file failed.
**/
EFI_STATUS
Heci2ReadNVMFile (
  IN     CONST  UINT8               *FileName,
  IN            UINT32              Offset,
  OUT           UINT8               *Data,
  IN OUT        UINTN               *DataSize,
  IN     CONST  EFI_HECI_PROTOCOL   *Heci2Protocol
  )
{
  //
  // HECI2 should only be accessed from SMM
  //
  return EFI_UNSUPPORTED;
}