/** @file
  Implementation file for CSE functionality in PEI Phase

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2006 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#include <MkhiMsgs.h>
#include <SeCAccess.h>
#include <Library/DebugLib.h>
#include <Library/HeciMsgLib.h>
#include <Library/PeiServicesLib.h>


/**
  Sets the HECI1 BAR value used until PCI enumeration.

  @param None

  @return EFI_SUCCESS  The HECI1 BAR was updated successfully.
**/
EFI_STATUS
EFIAPI
SetHeci1Bar (
  VOID
  )
{
  DEBUG ((DEBUG_INFO, "HeciPciRead32(R_SEC_DevID_VID)=%x\n", HeciPciRead32(R_SEC_DevID_VID)));
  DEBUG ((DEBUG_INFO, "Before HECI1 BAR0 Update: HECI1 BAR0 = %x\n", HeciPciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "Before HECI1 BAR1 Update: HECI1 BAR1 = %x\n", HeciPciRead32(HECI_BAR1)));

  HeciPciWrite32 (HECI_BAR0, 0xFFFFFFFF);         // BAR0  Dev 15 Func 0    10h bits 31:0
  HeciPciWrite32 (HECI_BAR1, 0xFFFFFFFF);         // BAR1  Dev 15 Func 0    14h bits 31:0
  HeciPciWrite32 (HECI_BAR0, FixedPcdGet32 (PcdHeci1TemporaryBaseAddress));  // BAR0  Dev 15 Func 0    10h bits 31:0
  HeciPciWrite32 (HECI_BAR1, 0);                  // BAR1  Dev 15 Func 0    14h bits 31:0
  HeciPciWrite32 (R_COMMAND, 0x106);              // Enable BAR Dev 15 Func 0    04h bits 8, 2:1
  HeciPciWrite32 (HECI_BAR0, 0xFFFFFFFF);         // BAR0  Dev 15 Func 0    10h bits 31:0
  HeciPciWrite32 (HECI_BAR1, 0xFFFFFFFF);         // BAR1  Dev 15 Func 0    14h bits 31:0
  HeciPciWrite32 (HECI_BAR0, FixedPcdGet32 (PcdHeci1TemporaryBaseAddress));  // BAR0  Dev 15 Func 0    10h bits 31:0
  HeciPciWrite32 (HECI_BAR1, 0);                  // BAR1  Dev 15 Func 0    14h bits 31:0

  DEBUG ((DEBUG_INFO, "After HECI1 BAR0 Update: HECI1 BAR0 = %x\n", HeciPciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "After HECI1 BAR1 Update: HECI1 BAR1 = %x\n", HeciPciRead32(HECI_BAR1)));

  return EFI_SUCCESS;
}

/**
  Sets the HECI2 BAR value used until PCI enumeration.

  @param[in] RestoreSavedBar Indicates the BAR parameter should be used.
  @param[in] Heci2Bar        The HECI2 BAR. Only used if RestoreSavedBar is TRUE.


  @return    EFI_SUCCESS         The HECI2 BAR was updated successfully.
  @return    EFI_NOT_STARTED     The HECI2 BAR could not be restored because the PEI
                                 SMM lockbox is not available.
  @return Others                 An error occurred restoring the HECI2 BAR
**/
EFI_STATUS
EFIAPI
SetHeci2Bar (
  IN BOOLEAN    RestoreSavedBar,
  IN UINT32     Heci2Bar          OPTIONAL
  )
{
  EFI_STATUS    Status = EFI_SUCCESS;

  if (!RestoreSavedBar) {
    Heci2Bar = FixedPcdGet32 (PcdHeci2BaseAddress);
  }

  DEBUG ((DEBUG_INFO, "Heci2PciRead32(R_SEC_DevID_VID)=%x\n", Heci2PciRead32(R_SEC_DevID_VID)));
  DEBUG ((DEBUG_INFO, "Before HECI2 BAR0 Update: HECI2 BAR0 = %x\n", Heci2PciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "Before HECI2 BAR1 Update: HECI2 BAR1 = %x\n", Heci2PciRead32(HECI_BAR1)));

  Heci2PciWrite32 (HECI_BAR0, 0xFFFFFFFF);  // BAR0  Dev 15 Func 1    10h bits 31:0
  Heci2PciWrite32 (HECI_BAR1, 0xFFFFFFFF);  // BAR1  Dev 15 Func 1    14h bits 31:0
  Heci2PciWrite32 (HECI_BAR0, Heci2Bar);    // BAR0  Dev 15 Func 1    10h bits 31:0
  Heci2PciWrite32 (HECI_BAR1, 0);           // BAR1  Dev 15 Func 1    14h bits 31:0
  Heci2PciWrite32 (R_COMMAND, 0x106);       // Enable BAR Dev 15 Func 1    04h bits 8, 2:1
  Heci2PciWrite32 (HECI_BAR0, 0xFFFFFFFF);  // BAR0  Dev 15 Func 1    10h bits 31:0
  Heci2PciWrite32 (HECI_BAR1, 0xFFFFFFFF);  // BAR1  Dev 15 Func 1    14h bits 31:0
  Heci2PciWrite32 (HECI_BAR0, Heci2Bar);    // BAR0  Dev 15 Func 1    10h bits 31:0
  Heci2PciWrite32 (HECI_BAR1, 0);           // BAR1  Dev 15 Func 1    14h bits 31:0

  DEBUG ((DEBUG_INFO, "After HECI2 BAR0 Update: HECI2 BAR0 = %x\n", Heci2PciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "After HECI2 BAR1 Update: HECI2 BAR1 = %x\n", Heci2PciRead32(HECI_BAR1)));

  return Status;
}

/**
  Sets the HECI3 BAR value used until PCI enumeration.

  @param None

  @return EFI_SUCCESS  The HECI3 BAR was updated successfully.
**/
EFI_STATUS
EFIAPI
SetHeci3Bar (
  VOID
  )
{
  DEBUG ((DEBUG_INFO, "Heci3PciRead32(R_SEC_DevID_VID)=%x\n", Heci3PciRead32(R_SEC_DevID_VID)));
  DEBUG ((DEBUG_INFO, "Before HECI3 BAR0 Update: HECI3 BAR0 = %x\n", Heci3PciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "Before HECI3 BAR1 Update: HECI3 BAR1 = %x\n", Heci3PciRead32(HECI_BAR1)));

  Heci3PciWrite32 (HECI_BAR0, 0xFFFFFFFF);         // BAR0  Dev 15 Func 2    10h bits 31:0
  Heci3PciWrite32 (HECI_BAR1, 0xFFFFFFFF);         // BAR1  Dev 15 Func 2    14h bits 31:0
  Heci3PciWrite32 (HECI_BAR0, FixedPcdGet32 (PcdHeci3BaseAddress)); // BAR0  Dev 15 Func 2    10h bits 31:0
  Heci3PciWrite32 (HECI_BAR1, 0);                  // BAR1  Dev 15 Func 2    14h bits 31:0
  Heci3PciWrite32 (R_COMMAND, 0x106);              // Enable BAR Dev 15 Func 2    04h bits 8, 2:1
  Heci3PciWrite32 (HECI_BAR0, 0xFFFFFFFF);         // BAR0  Dev 15 Func 2   10h bits 31:0
  Heci3PciWrite32 (HECI_BAR1, 0xFFFFFFFF);         // BAR1  Dev 15 Func 2    14h bits 31:0
  Heci3PciWrite32 (HECI_BAR0, FixedPcdGet32 (PcdHeci3BaseAddress)); // BAR0  Dev 15 Func 2    10h bits 31:0
  Heci3PciWrite32 (HECI_BAR1, 0);                  // BAR1  Dev 15 Func 2   14h bits 31:0

  DEBUG ((DEBUG_INFO, "After HECI3 BAR0 Update: HECI3 BAR0 = %x\n", Heci3PciRead32(HECI_BAR0)));
  DEBUG ((DEBUG_INFO, "After HECI3 BAR1 Update: HECI3 BAR1 = %x\n", Heci3PciRead32(HECI_BAR1)));

  return EFI_SUCCESS;
}
