// (C) 2020 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module ADR(
	input  iClk,//%Clock input
	input  iRst_n,//%Reset enable on high
	input  i10uSCE, //% 10 uS Clock Enable

	input   PWRGD_PS_PWROK,			//falling flank triggers ADR

	input 	FM_SLPS4_N,
	input   FM_PS_EN, //MAsking signal for PS_PWROK
	input   PWRGD_CPUPWRGD, //% Pwrgd CPU from PCH, without delay
	input 	RST_PLTRST_N,

	input   FM_PS_PWROK_DLY_SEL,  //%from PCH, 0 delay 15ms, 1 delay 600us(default)
	input   FM_DIS_PS_PWROK_DLY, //% Disable delay from PWRGD_PS (0 DLY power-down condition)

	input   FM_ADR_COMPLETE,  //%ADR complete from PCH
	input   FM_PLD_PCH_DATA,  //%DATAfrom PCH, 0 to disable NVDIMM function, 1 to enable NVDIMM(default)

	output  FM_ADR_SMI_GPIO_N,  //% GPIO to PCH
	output  FM_ADR_TRIGGER_N,  //% ADR Trigger# to PCH
	output  FM_ADR_COMPLETE_DLY,//% copy of FM_ADR_COMPLETE (no delay added)
	output  PWRGD_PS_PWROK_DLY_ADR //% PWRGD_PS_PWROK delay add acording ADR logic SEL 0 delay 15ms, 1 delay 600us(default)
);

localparam	IDLE		= 0;
localparam	DETECT		= 1;
localparam	eADR		= 2;
localparam	HOLD		= 3;
localparam	ADR			= 4;
localparam	COMPLETE	= 5;
localparam 	HIGH = 1'b1;
localparam 	LOW = 1'b0;

reg [2:0]	rState;
reg  rFM_ADR_SMI_GPIO_N, rFM_ADR_TRIGGER_N, rFM_ADR_COMPLETE_DLY, rPWRGD_PS_PWROK_DLY_ADR;

always@(negedge iClk, negedge iRst_n) begin
	if (!iRst_n) begin
		rState <= IDLE;
	end
	else begin
		case(rState)
			DETECT: begin //Waits for PSU faulure or eADR
				rState <=
					(!PWRGD_PS_PWROK && FM_PLD_PCH_DATA)						?	ADR		:
					(!PWRGD_PS_PWROK)											?	eADR	:
					(FM_SLPS4_N && FM_PS_EN && PWRGD_CPUPWRGD && RST_PLTRST_N)	?	DETECT	:
																					IDLE	;
			end
			eADR: begin
				rState <=
					(FM_PLD_PCH_DATA)	?	HOLD	:
											eADR	;
			end
			HOLD: begin
				rState <= ADR	;
			end
			ADR: begin
				rState <=
					(FM_ADR_COMPLETE)	?	COMPLETE	:
											ADR			;
			end
			COMPLETE: begin
				rState <=
					(FM_ADR_COMPLETE)	?	COMPLETE	:
												IDLE	;
			end
			default: begin //IDLE
				rState <=
					(FM_SLPS4_N && FM_PS_EN && PWRGD_CPUPWRGD && RST_PLTRST_N)	?	DETECT	:
																					IDLE	;
			end
		endcase
	end
end

always@(*) begin
	case(rState)
		DETECT: begin
			rFM_ADR_TRIGGER_N		= HIGH;
			rFM_ADR_SMI_GPIO_N		= HIGH;
			rFM_ADR_COMPLETE_DLY	= LOW;//active high
			rPWRGD_PS_PWROK_DLY_ADR = HIGH;
		end
		eADR: begin
			rFM_ADR_TRIGGER_N		= HIGH;
			rFM_ADR_SMI_GPIO_N		= LOW;
			rFM_ADR_COMPLETE_DLY	= LOW;
			rPWRGD_PS_PWROK_DLY_ADR = HIGH;
		end
		HOLD: begin
			rFM_ADR_TRIGGER_N		= HIGH;
			rFM_ADR_SMI_GPIO_N		= HIGH;
			rFM_ADR_COMPLETE_DLY	= LOW;
			rPWRGD_PS_PWROK_DLY_ADR = HIGH;
		end
		ADR: begin
			rFM_ADR_TRIGGER_N		= LOW;
			rFM_ADR_SMI_GPIO_N		= HIGH;
			rFM_ADR_COMPLETE_DLY	= LOW;
			rPWRGD_PS_PWROK_DLY_ADR = HIGH;
		end
		COMPLETE: begin
			rFM_ADR_TRIGGER_N		= HIGH;
			rFM_ADR_SMI_GPIO_N		= HIGH;
			rFM_ADR_COMPLETE_DLY	= FM_ADR_COMPLETE;
			rPWRGD_PS_PWROK_DLY_ADR = LOW;
		end
		default: begin
			rFM_ADR_TRIGGER_N		= HIGH;
			rFM_ADR_SMI_GPIO_N		= HIGH;
			rFM_ADR_COMPLETE_DLY	= LOW;//active high
			rPWRGD_PS_PWROK_DLY_ADR = PWRGD_PS_PWROK;
		end
	endcase
end

assign FM_ADR_TRIGGER_N			= rFM_ADR_TRIGGER_N;
assign FM_ADR_SMI_GPIO_N		= rFM_ADR_SMI_GPIO_N;
assign FM_ADR_COMPLETE_DLY		= rFM_ADR_COMPLETE_DLY;
assign PWRGD_PS_PWROK_DLY_ADR	= rPWRGD_PS_PWROK_DLY_ADR;

endmodule
