############################################
#
# Boost!
#
# note: after boost is found the following are defined:
# Boost_INCLUDE_DIRS     - Boost include directories
# Boost_LIBRARY_DIRS     - Link directories for Boost libraries
# Boost_LIBRARIES        - Boost component libraries to be linked
# for more info see http://www.cmake.org/cmake/help/v3.0/module/FindBoost.html
#
#set(Boost_DEBUG ON) # enable this to debug cmake/boost search issues
set(Boost_NAMESPACE "boost_openipc")
set(Boost_USE_STATIC_LIBS    ON)
set(Boost_USE_MULTITHREADED  ON)
set(Boost_NO_SYSTEM_PATHS    ON) # Don't look in system paths for the Boost libraries

if(WIN32)
    add_definitions(-DBOOST_ALL_NO_LIB) # disable auto-link in MSVC
    set(Boost_COMPILER "-vc141")
endif()

set(BOOST_VERSION "1.68.0")
set(BOOST_ROOT_DIR "${THIRDPARTY_ROOT}/Boost/${BOOST_VERSION}")
set(BOOST_INCLUDEDIR "${BOOST_ROOT_DIR}/include")
set(BOOST_LIBRARYDIR "${BOOST_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}")

set(BOOST_REQUIRED_COMPONENTS log filesystem thread chrono system random)

if(WIN32)
    set(BOOST_REQUIRED_COMPONENTS ${BOOST_REQUIRED_COMPONENTS} locale)
endif()

find_package(Boost ${BOOST_VERSION} REQUIRED COMPONENTS ${BOOST_REQUIRED_COMPONENTS})
foreach(COMPONENT IN LISTS BOOST_REQUIRED_COMPONENTS)
    list(APPEND EXCLUDE_SYMBOL_EXPORT_LIBS lib${Boost_NAMESPACE}_${COMPONENT}.a)
endforeach()

ShipSources(SYSTEM_DIRECTORIES "${BOOST_ROOT_DIR}"
            DIRECTORIES "${BOOST_ROOT_DIR}/include"
            FILES "${BOOST_ROOT_DIR}/boost_1_68_0.tar.gz"
                  "${BOOST_ROOT_DIR}/Building_On_All_Platforms.txt"
                  "${BOOST_ROOT_DIR}/LICENSE_1_0.txt")
