
/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief small adaptations to Darwin/OSX
///
//////////////////////////////////////////////////////////////////////////////

#pragma once

#if defined(HOST_DARWIN)

#include <time.h>
#include <sys/time.h>
#include <mach/clock.h>
#include <mach/mach.h>

/*!
\brief this doesnt exist on darwin...
*/
inline int pthread_mutex_timedlock(pthread_mutex_t *mutex, timespec *timeout)
{
    struct timeval currenttime;
    struct timespec timetosleep;
    int ret;

    timetosleep.tv_sec = 0;
    timetosleep.tv_nsec = 10000000; // 10ms

    while ((ret = pthread_mutex_trylock (mutex)) == EBUSY) {
        gettimeofday(&currenttime, NULL);

        if(currenttime.tv_sec >= timeout->tv_sec &&
          (currenttime.tv_usec * 1000) >= timeout->tv_nsec) {
            return ETIMEDOUT;
        }

        nanosleep (&timetosleep, NULL);
    }

    return ret;
}

/*!
\brief darwin does not support pthread_timedjoin_np

pthread_timedjoin_np is a linux-only function with no clear equivilent on darwin
*/
#define pthread_timedjoin_np(a, b, c) pthread_join(a, b)

#endif

