/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Implementation of the fileexists() function that determines whether a
///        file exists.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "fileexists.h"

#ifdef _WIN32
  #include <io.h>      // for _access()
  #include <codecvt>
#else
  #include <unistd.h>  // for access()
#endif

namespace InternalUtils
{

    // Helper function to determine if a file exists or not.
    bool fileexists(const char* pFilename)
    {
        const int ACCESS_MODE_EXISTS = 0;
        const int MODE_EXISTS = 0;
        const int MODE_ERROR = -1;

        int accessState = MODE_EXISTS;
#ifdef _WIN32
        std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>, wchar_t> converter;
	    accessState = _waccess(converter.from_bytes(pFilename).c_str(), ACCESS_MODE_EXISTS);
#else
	    accessState = access(pFilename, ACCESS_MODE_EXISTS);
#endif
        return accessState != MODE_ERROR;
    }

} // end namespace InternalUtils
