/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of a function to locate the DAL's registered location.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __INTERNAL_LOCATEDAL_H__
#define __INTERNAL_LOCATEDAL_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: locatedal
    //
    /// @brief Retrieve the registered location of the DAL.
    ///
    /// This helper function returns the path to the folder where the DAL
    /// is registered.  If the DAL is not registered, returns an empty
    /// string.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @par Parameters:
    ///   None.
    ///
    /// @return (std::string):
    ///   Returns a string containing the path to the folder containing the
    ///   DAL.  If the DAL is not registered, returns an empty string.
    ///
    /// @par Example:
    ///   None.
    //////////////////////////////////////////////////////////////////////////
    std::string locatedal();

    //////////////////////////////////////////////////////////////////////////
    //  Function: locateopenipc
    //
    /// @brief Retrieve the registered location of the OpenIPC.
    ///
    /// This helper function returns the path to the folder where the OpenIPC
    /// is registered.  If the OpenIPC is not registered, returns an empty
    /// string.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @par Parameters:
    ///   None.
    ///
    /// @return (std::string):
    ///   Returns a string containing the path to the folder containing the
    ///   OpenIPC.  If the OpenIPC is not registered, returns an empty string.
    ///
    /// @par Example:
    ///   None.
    //////////////////////////////////////////////////////////////////////////
    std::string locateopenipc();

} // end namespace InternalUtils

#endif // __INTERNAL_LOCATEDAL_H__
