/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Implementation of the removefile() function that deletes a file.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include <errno.h>
#include "removefile.h"

#ifdef _WIN32
    #include <codecvt>
#endif

namespace InternalUtils
{

    int removefile(const char* pFilename)
    {
        int err = -1;

        if (pFilename != NULL)
        {
#ifdef _WIN32
            std::wstring_convert<std::codecvt_utf8_utf16<wchar_t>, wchar_t> converter;
            err = _wremove(converter.from_bytes(pFilename).c_str());
#else
            err = remove(pFilename);
#endif
        }
        else
        {
            errno = EINVAL;
        }

        return err;
    }

} // end namespace InternalUtils
