/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the renamefile() function that renames a file.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __RENAMEFILE_H__
#define __RENAMEFILE_H__

namespace InternalUtils
{

    // Rename a file.  Returns 0 if successful; otherwise, returns -1 (consult
    // errno for details).

    //////////////////////////////////////////////////////////////////////////
    //  Function: renamefile
    //
    /// @brief Rename a file on disk.
    ///
    /// This helper function changes the name of a file.
    ///
    /// @par Assumptions:
    ///   The file exists.
    ///
    /// @par Side Effects:
    ///   The file, if it exists and can be renamed, is renamed.
    ///
    /// @param pOldFilename
    ///    The path to the file to rename.
    /// @param pNewFilename
    ///    The name of the new file.
    ///
    /// @return (int):
    ///     Returns 0 if successful; otherwise, returns -1.  Consult errno for
    ///     details.
    //////////////////////////////////////////////////////////////////////////
    int renamefile(
        const char* pOldFilename,
        const char* pNewFilename);

} // end namespace InternalUtils

#endif // __RENAMEFILE_H__
