#include "stdafx.h"
#include "setenvvar.h"

/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Implementation of the setenvvar() function.
///
/// This utility function hides the platform-specific details of setting the
/// value of an environment variable.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdlib.h>

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: setenvvar
    //
    //////////////////////////////////////////////////////////////////////////
    int setenvvar(const char* varName, const char* varValue)
    {
        int ret = 0;

        if (varName != NULL)
        {
#ifdef _MSC_VER
            if (varValue == NULL)
            {
                varValue = "";
            }
            ret = _putenv_s(varName, varValue);
#else
            if (varValue != NULL && varValue[0] != '\0')
            {
                ret = setenv(varName, varValue, 1); // 1 = overwrite existing variable
            }
            else
            {
                ret = unsetenv(varName);
            }
#endif
        }
        return ret;
    }

} // end namespace InternalUtils
