/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the skipwhitespace() function.
///
/// This utility function hides the details of skipping leading whitespace
/// in a given string.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __SKIPWHITESPACE_H__
#define __SKIPWHITESPACE_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////////
    //  Function: skipwhitespace
    //
    /// @brief Skips leading white space in the given string by returning an
    ///        pointer to the first non-whitespace in the string.
    ///
    /// This function skips over leading spaces, tabs, and newlines in the given
    /// string and returns a pointer to the first non-whitespace in the string.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param[in] line
    ///   A pointer to the zero-terminated string to examine.
    ///
    /// @return (const char*):
    ///   A pointer to the first non-whitespace character in the string.
    //////////////////////////////////////////////////////////////////////////////
    const char* skipwhitespace(const char* line);

} // end InternalUtils namespace

#endif //__SKIPWHITESPACE_H__
