/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the sprintf_safe() function.
///
/// This utility function is a "safe" version of the sprintf() standard C
/// library funtion that prevents buffer overruns.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __SPRINTF_SAFE__
#define __SPRINTF_SAFE__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////////
    //  Function: sprintf_safe
    //
    /// @brief A platform-independent "safe" version of sprintf(), that protects
    ///        against buffer overruns.
    ///
    /// This function is a "safe" implementation of the standard C Library
    /// sprintf() function.  This version prevents buffer overruns.  This
    /// function also guarantees a zero terminator is added even if it
    /// truncates the buffer.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The specified buffer is modified.
    ///
    /// @param[out] szBuffer
    ///   A buffer in which to put the formatted text.
    /// @param[in]  nSize
    ///   The maximum number of characters that can fit in the buffer, including
    ///   the zero terminator.
    /// @param[in] szFormatStr
    ///   The format string that specifies the formatted output.  The remaining
    ///   parameters, if any, are arguments to the format string.  This is the same
    ///   format string as passed to sprintf().
    ///   
    ///
    /// @return (int): The number of characters written to the buffer, not
    ///                including the zero terminator.  If the buffer is not large
    ///                enough, returns -1.  The string is always zero-terminated.
    //////////////////////////////////////////////////////////////////////////////
    int sprintf_safe(char* szBuffer, int nSize, const char* szFormatStr, ...);

} // end namespace InternalUtils


#endif // __SPRINTF_SAFE__
