/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Implementation of the stringcopy() functions.
///
/// This utility function provides a platform-independent way to safely copy a
/// string into a buffer.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <errno.h>
#include "stringcopy.h"

namespace InternalUtils
{

    int stringcopy(
        char*       destBuffer,
        size_t      destBufferMaxSize,
        const char* sourceBuffer)
    {
        int retval = EINVAL;
        if (destBuffer != nullptr && sourceBuffer != nullptr && destBufferMaxSize != 0)
        {
            // decrement first so we leave room for the null terminator
            while(--destBufferMaxSize > 0)
            {
                *destBuffer = *sourceBuffer;
                if (*sourceBuffer == '\0')
                {
                    return 0;
                }
                ++destBuffer;
                ++sourceBuffer;
            }
            *destBuffer = '\0';
            retval = 0;
        }
        return retval;
    }

} // end namespace InternalUtils
