/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the stringcopy() functions.
///
/// This utility function provides a platform-independent way to safely copy a
/// string into a buffer.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __STRINGCOPY_H__
#define __STRINGCOPY_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: stringcopy
    //
    /// @brief Safely copy a string into a destination buffer.
    ///
    /// This helper function copies a string into a destination buffer,
    /// making sure the string is zero-terminated and doesn't overflow the
    /// destination buffer.
    ///
    /// @par Assumptions:
    ///   The @a destBufferMaxSize is really the size of the @a destBuffer
    ///   buffer.
    ///
    /// @par Side Effects:
    ///   The destination buffer is altered to contain the source string.
    ///
    /// @param destBuffer
    ///     The buffer in which to copy the string.
    /// @param destBufferMaxSize
    ///     The maximum number of characters, including zero-terminator, that
    ///     can fit into the destination buffer.
    /// @param sourceBuffer
    ///     The source string to copy into the destination buffer.
    ///
    /// @return (int):
    ///     Returns 0 for success; otherwise, returns an error code.
    /// @retval eINVAL
    ///     The @a destBuffer or @a sourceBuffer parameters are NULL or the
    ///     @a destBufferMaxSize parameter is 0.
    //////////////////////////////////////////////////////////////////////////
    int stringcopy(
        char*       destBuffer,
        size_t      destBufferMaxSize,
        const char* sourceBuffer);

} // end namespace InternalUtils

#endif // __STRINGCOPY_H__
