/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of types and defines used in the various threading
///        functions.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __THREADTYPES_H__
#define __THREADTYPES_H__

#if !defined(_MSC_VER) || _MSC_VER >= 1600
#include <stdint.h>
#endif

namespace InternalUtils
{

#if defined(_MSC_VER) && _MSC_VER < 1600

typedef unsigned __int32 TimeoutDelay;

#else

typedef uint32_t         TimeoutDelay;

#endif

    // Error code returned by jointhread().
    const int eSRCH     = ESRCH;   ///< The thread handle does not correspond to a valid thread.
    const int eINVAL    = EINVAL;  ///< The thread handle is invalid.
#if defined(MSC_VER) && _MSC_VER < 1600
    const int eTIMEDOUT = 138;     ///< (ETIMEDOUT) The join or wait timed out waiting for thread to terminate.
#else
    const int eTIMEDOUT = ETIMEDOUT; ///< The join or wait timed out waiting for thread to terminate.
#endif
    const int eDEADLK   = EDEADLK; ///< (EDEADLOCK) Deadlock detected (two threads trying to join each other)

    // Error code returned by unlockmutex().
    const int eNOTOWNED = 300; ///< A mutex is not owned by the thread (not POSIX but I needed something)

    /// Handle to the thread.
    typedef unsigned int ThreadHandle;

    /// Handle to the thread event object.
    typedef unsigned int ThreadEventHandle;

    /// Handle to the mutex object.
    typedef unsigned int MutexHandle;


    /// Indicates that jointhread() should wait forever.
    const TimeoutDelay TIMEOUT_INFINITE = static_cast<TimeoutDelay>(-1);

} // end namespace InternalUtils

#endif // __THREADTYPES_H__
