/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#include "stdafx.h"
#include "timestamp.h"

#include <chrono>
#include <ctime>
#include <iomanip>
#include <sstream>

std::string InternalUtils::GetTimestamp()
{
    auto now = std::chrono::system_clock::now();
    auto currentTime = std::chrono::system_clock::to_time_t(now);
    auto epochTime = now.time_since_epoch();
    auto fraction = epochTime - std::chrono::duration_cast<std::chrono::seconds>(epochTime);
    uint32_t milliseconds = static_cast<uint32_t>(fraction / std::chrono::milliseconds(1));

    std::stringstream ss;
    std::tm timeStruct;
#if defined(_WIN32)
    if (localtime_s(&timeStruct, &currentTime) != 0)
    {
        return "";
    }
#else
    if (localtime_r(&currentTime, &timeStruct) == nullptr)
    {
        return "";
    }
#endif
    ss << std::put_time(&timeStruct, "%Y-%m-%d %H:%M:%S") << "," << std::setw(3) << std::setfill('0') << milliseconds;

    return ss.str();
}

