/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the ui64tostring() function.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __UI64TOSTRING_H__
#define __UI64TOSTRING_H__

#include <errno.h>
#include <string>

#if !defined(_MSC_VER) || _MSC_VER >= 1600
#include <stdint.h>
#endif

namespace InternalUtils
{
#if defined(_MSC_VER) && _MSC_VER < 1600

    typedef __int64          IU_INT64;
    typedef unsigned __int64 IU_UINT64;

#else

    typedef int64_t          IU_INT64;
    typedef uint64_t         IU_UINT64;

#endif

    //////////////////////////////////////////////////////////////////////////
    //  Function: ui64todecimalstring
    //
    /// @brief Converts an unsigned 64-bit integer to a decimal string, prefixed
    ///        by spaces as necessary to the given width.
    ///
    /// This helper function formats an unsigned 64-bit integer into a string
    /// of decimal characters.  Optionally, the number is padded with spaces
    /// on the leading edge to a given width.  If the number is larger than
    /// the given width, no padding is added.  The string is guaranteed to be
    /// at least the given width in characters but it can be longer.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param value
    ///     The 64-bit unsigned integer to convert.
    /// @param width
    ///     The optional minimum width of the string to return, prefixed by
    ///     spaces as necessary.
    ///
    /// @return (std::string):
    ///     Returns a string containing the decimal representation of the value.
    //////////////////////////////////////////////////////////////////////////
    std::string ui64todecimalstring(IU_UINT64 value, size_t width = 0);

    //////////////////////////////////////////////////////////////////////////
    //  Function: ui64tohexadecimalstring
    //
    /// @brief Converts an unsigned 64-bit integer to a hexadecimal string,
    ///        prefixed by 0's as necessary to the given width.
    ///
    /// This helper function formats an unsigned 64-bit integer into a string
    /// of hexadecimal characters.  Optionally, the number is padded with 0's
    /// on the leading edge to a given width.  If the number is larger than
    /// the given width, no padding is added.  The string is guaranteed to be
    /// at least the given width in characters but it can be longer.
    ///
    /// The resulting string is always prefixed with the characters "0x".
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param value
    ///     The 64-bit unsigned integer to convert.
    /// @param width
    ///     The optional minimum width of the string to return, prefixed by
    ///     0's as necessary.
    /// @param useUpperCase
    ///     true if to force the letters in the haexdecimal string to be
    ///     uppercase; otherwise, the default is to use lowercase letters.
    ///
    /// @return (std::string):
    ///     Returns a string containing the hexadecimal representation of the
    ///     value, prefixed with "0x".
    //////////////////////////////////////////////////////////////////////////
    std::string ui64tohexadecimalstring(IU_UINT64 value, size_t width = 0, bool useUpperCase = false);

} // end namespace InternalUtils

#endif // __UI64TOSTRING_H__
