
set(Public_Include_Headers "../../Public_Include/Components/Common/Common.h"
                           "../../Public_Include/Components/Common/CommonErrors.h"
                           "../../Public_Include/Components/Common/CommonTypes.h")
set(HeaderFiles_Headers "CommonImpl.h"
                        "stdafx.h")
set(SourceFiles_Sources "CommonErrors.cpp"
                        "CommonImpl.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Public_Include" FILES ${Public_Include_Headers} )
source_group("Header Files" FILES ${HeaderFiles_Headers} )
source_group("Source Files" FILES ${SourceFiles_Sources} )

set(SOURCES ${SOURCES} ${CMakeIncludes} ${Public_Include_Headers} ${HeaderFiles_Headers} ${SourceFiles_Sources} CMakeLists.txt)

ShipSources(FILES ${SOURCES})

if(WIN32)
    configure_file(
      ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
      ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
      @ONLY)

    set(ResourceFiles "${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc")

    source_group("Resource Files" FILES ${ResourceFiles})
    set(SOURCES ${SOURCES} ${ResourceFiles})
endif()
