#pragma once

#include "ASDBaseProtocol.h"
#include "ConnectionParameters.h"

class ASDProtocol : public ASDBaseProtocol
{
public:
	ASDProtocol(std::shared_ptr<Transport> transport, std::shared_ptr<ProbeInstanceASD> probe, std::shared_ptr<ConnectionParameters> connectionParameters);
	Connection_Error SetHardwareLogLevel(LoggingConfiguration log_config);
	Connection_Error SetHardwareGpioConfig(const uint8_t gpio_config);
	Connection_Error SetHardwareJTAGDriverMode(JtagChainParameters params);
	virtual Connection_Error StartDataTransfer(unsigned int messageType, JtagChainParameters *params = NULL);
	virtual Connection_Error EndDataTransfer(JtagChainParameters *params = NULL);
	virtual Connection_Error UpdateInterfacePaddingSettings(InterfacePadding *interfacePaddingSettings);
	ASDProtocol(const ASDProtocol& other) = delete;
	ASDProtocol& operator= (ASDProtocol&& other) = delete;
	ASDProtocol();

protected:
	virtual unsigned int readPacket(void);
	Connection_Error SetHWStateToTheOutMsg(JtagChainParameters *_params);
	Connection_Error ClearPRDYTimeout(void);
	Connection_Error DecryptData(struct message *message);
	Connection_Error EncryptData(struct message *message);
	Connection_Error ProcessReadBuffers(struct message*, std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> tmp_input_list);
	Connection_Error ProcessReadBuffersI2c(struct message*, std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> tmp_input_list);
	Connection_Error ProcessI2cReadResponse(struct message*, size_t pos, std::shared_ptr<OutputBuffers> tmp_input);
	Connection_Error ProcessI2cWriteResponse(struct message*, size_t pos, std::shared_ptr<OutputBuffers> tmp_input);
	Connection_Error doubleShiftCheck(JtagStateEncode state);
	Connection_Error ShiftJTAGProtocol(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt);
	Connection_Error ShiftI2cProtocol(OpenIPC_DeviceId deviceId, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt);
	Connection_Error checkPayloadSize(size_t size);
	Connection_Error AddOutputBuffer(char*, size_t, char, uint16_t, GotoStateOptions);
	Connection_Error BuildBitVecBuffer(uint8_t toSend);
	void init();

	JtagStateEncode			lastjtagstate;
	bool setWaitPRDYtimeoutSent; // Wait for PRDY timeout setting, only needs to be sent once per connection
	JtagChainInfo jtagSettings;
	InterfacePadding padding;
	JtagChainParameters params;
	std::vector<uint8_t> multiChainBitVec;
	uint8_t largestId;
	bool multiChainDataActive;
};