#ifndef OPENIPC_OSDEPENDENCIES_H
#define OPENIPC_OSDEPENDENCIES_H

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
typedef int OSDepSocket;
#else
#include <winsock2.h>
typedef SOCKET OSDepSocket;
#endif

class OSDependencies {
public:
	virtual OSDepSocket InitSocket() = 0;
	virtual bool IsSocketValid(OSDepSocket socket) = 0;
	virtual OSDepSocket Socket(int socket_family, int socket_type, int protocol) = 0;
	virtual int GetAddressInfo(const char *__name, const char * __service,
		const struct addrinfo *_req, struct addrinfo **__pai) = 0;
	virtual void FreeAddressInfo(struct addrinfo *__ai) = 0;
	virtual bool SetSockOptKeepAlive(OSDepSocket s) = 0;
	virtual bool SetSockOptNoDelay(OSDepSocket s) = 0;
	virtual int Connect(OSDepSocket sockfd, const void *addr, unsigned int addrlen) = 0;
	virtual int Close(OSDepSocket sockfd) = 0;
	virtual int Send(OSDepSocket sockfd, const void *buf, int len, int flags) = 0;
	virtual int Receive(OSDepSocket sockfd, void *buf, int len, int flags) = 0;
	virtual bool AwaitData(OSDepSocket sockfd) = 0;
};

#endif //OPENIPC_OSDEPENDENCIES_H
