#ifndef OPENIPC_OSDEPENDENCIESIMPL_H
#define OPENIPC_OSDEPENDENCIESIMPL_H

#include "OSDependencies.h"

class OSDependenciesImpl : public OSDependencies {
	OSDepSocket InitSocket() override;
	bool IsSocketValid(OSDepSocket socket) override;
	OSDepSocket Socket(int socket_family, int socket_type, int protocol) override;
	int GetAddressInfo(const char *__name, const char * __service,
		const struct addrinfo *_req, struct addrinfo **__pai) override;
	void FreeAddressInfo(struct addrinfo *__ai) override;
	bool SetSockOptKeepAlive(OSDepSocket s) override;
	bool SetSockOptNoDelay(OSDepSocket s) override;
	int Connect(OSDepSocket sockfd, const void *addr, unsigned int addrlen) override;
	int Close(OSDepSocket sockfd) override;
	int Send(OSDepSocket sockfd, const void *buf, int len, int flags) override;
	int Receive(OSDepSocket sockfd, void *buf, int len, int flags) override;
	bool AwaitData(OSDepSocket sockfd) override;
public:
        virtual ~OSDependenciesImpl() {}
};

#endif //OPENIPC_OSDEPENDENCIESIMPL_H
