#pragma once
#include <memory>
#include "ConnectionError.h"
#include <Foundation/Types.h>
#include <TapStateMachineEncode.h>
#include <GotoStateOptions.h>
#include <JtagChainParameters.h>
class Transport;
class ProbeInstanceASD;
class Protocol {
public:
	virtual Connection_Error ShiftJTAG(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt) = 0;
	virtual Connection_Error ShiftI2C(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt) = 0;
	virtual Connection_Error Flush(Connection_Error readResult = No_Error) = 0;
	virtual bool DataFlushed(void) = 0;
	virtual void ReceiveData(void) = 0;
	virtual Connection_Error StartDataTransfer(unsigned int messageType, JtagChainParameters *params = NULL) = 0;
	virtual Connection_Error EndDataTransfer(JtagChainParameters *params = NULL) = 0;
	virtual Connection_Error UpdateInterfacePaddingSettings(InterfacePadding *interfacePaddingSettings) = 0;
	virtual Connection_Error ConnectionEstablished() = 0;
	virtual Connection_Error SetHardwareLogLevel(LoggingConfiguration) = 0;
	virtual Connection_Error SetHardwareGpioConfig(const uint8_t) = 0;
	virtual Connection_Error SetHardwareJTAGDriverMode(JtagChainParameters) = 0;
};
