#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "SSLMethod.hpp"

#include <openssl/ssl.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/conf.h>
#include <openssl/x509.h>
#include <openssl/buffer.h>
#include <openssl/x509v3.h>
#include <openssl/opensslconf.h>

class SSLMethodOpenSSL : public SSLMethod
{
public:
	SSLMethodOpenSSL();
	bool Open(std::string &address, std::string &port, std::string &targetChainFile) override;
	int Close() override;
	void RegisterErrorHandler(std::function<void(SSL_Error error, std::string message)> errorHandlerFunction) override;
	int Write(char *buffer, int length) override;
	int Read(char *buffer, int size) override;
	int Getfd() override;
	int Pending() override;
	void SetConfig(SSL_Config config) override;
	SSL_Config GetConfig() override;

	~SSLMethodOpenSSL() override;
	SSL_Error GetVerifyResult();
	const char* const PREFERRED_CIPHERS = "HIGH:!aNULL:!kRSA:!SRP:!PSK:!CAMELLIA:!RC4:!MD5:!DSS";
private:
	std::function<void(SSL_Error error, std::string message)> errorHandler;
	static int VerifyCallback(int preverify, X509_STORE_CTX* x509_ctx);
	void CheckConnectionThread();
	unsigned long ssl_error;
	const SSL_METHOD *method;
	SSL_CTX *ctx;
	long response;
	BIO *bmcConnection;
	SSL *ssl;
	SSL_Config config;
};

// Used to store result of VerifyCallback
static SSL_Error VerifyResult = SSL_Error::General_Warning;
