#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "TransportSocket.hpp"
#include "SSLMethod.hpp"
#include "OSDependencies.h"

class TransportTLS : public Transport
{
public:
	TransportTLS(const char* address, const char* port,
		const char* targetChainFile, std::shared_ptr<SSLMethod> sslMethod,
		std::shared_ptr<OSDependencies> deps);

	Connection_Error Connect() override;
	int Send(char *send_buffer, int length) override;
	int Receive(char *buffer, int length) override;
	bool AwaitData() override;
	void Close() override;
	void ForEachWarningAndError(unsigned int warning_notificaiton_type,
		unsigned int error_notification_type, std::function<void(unsigned int,
			std::string)> log_function) override;
	void RegisterMessage(TransportMessage message);  // Add warning and error messages
	void SSLErrorHandler(SSL_Error error, std::string message);
	virtual ~TransportTLS();
	bool MoreData;
protected:
	std::list<TransportMessage> Messages;
	const char* TargetChainFile;
	std::shared_ptr<SSLMethod> SslMethod;
	std::shared_ptr<OSDependencies> Dependencies;
};
