#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////

#include "CProbePlugin.hpp"
#include "RemoteConnection.h"
#include <map>

#define FPGA_BASE_FREQ 50000000
#define WAIT_CYCLES_LOG 0x10

#define STATE_CHANGE_BYTE 0x20
#define WRITE_SCAN 0x40
#define READ_SCAN 0x80
#define RW_SCAN 0xC0
#define MAX_RW_SCAN_SIZE 8
#define TARGET_RESET 0x1

#define WAIT_TIME 1000 //we will wait for the server to respond for 1s

struct PPI_InterfaceTriggerResponseResetBreak : PPI_InterfaceTriggerResponse
{
private:
	std::shared_ptr<ProbeInstanceASD> probe;

public:
	PPI_InterfaceTriggerResponseResetBreak(uint32_t identifier, bool triggerOnAssert,
										PPI_Pins_TypeEncode trigger, bool respondWithAssert,
										PPI_Pins_TypeEncode response, bool observable, std::shared_ptr<ProbeInstanceASD> probe) :
	    PPI_InterfaceTriggerResponse(identifier, triggerOnAssert, trigger, respondWithAssert, response, observable), probe(probe)
	{
	}
	virtual OpenIPC_Error SetIsEnabled(bool enabled);
	virtual ~PPI_InterfaceTriggerResponseResetBreak(){}
};
