include_directories("${OPENIPC_ROOT}/Source/Public_Include"
					"${OPENIPC_ROOT}/Source/Foundation/StructuredData_Static"
					"${OPENIPC_ROOT}/Source/PluginSDK/Probe/Source/PluginAdapter_static"
					"${CMAKE_CURRENT_SOURCE_DIR}/../ASD_Connection_Static"
					"${CMAKE_CURRENT_SOURCE_DIR}/../ASD_Connection"
					"${CMAKE_CURRENT_SOURCE_DIR}/../ASD_JTAG_Static")

set(HeaderFiles_Headers "ASD_JTAG.hpp"
						"stdafx.h"
)
set(SourceFiles_Sources "ASD_JTAG.cpp"
)

set(SourceFiles_Sources_Windows "dllmain.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})

set(SOURCES ${SOURCES} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes} CMakeLists.txt)

ShipSources(FILES ${SOURCES} ${SourceFiles_Sources_Windows})

if(WIN32)
	configure_file(
	  ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
	  ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
	  @ONLY)

	set(ResourceFiles "./Generated/resource.rc")
	set(SOURCES ${SOURCES} ${ResourceFiles})
	source_group("Resource Files" FILES ${ResourceFiles})

	source_group("Source Files" FILES ${SourceFiles_Sources_Windows})
	set(SOURCES ${SOURCES} ${SourceFiles_Sources_Windows})
endif()
