//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "BundleFilter.h"
#include <Components/Common/CommonErrors.h>

BundleFilter::BundleFilter() : nextFilter(NULL) {}

void BundleFilter::Append(std::shared_ptr<BundleFilter> filter) {
	nextFilter = filter;
}

OpenIPC_Error BundleFilter::Execute(Local_Handle *bundle, OpenIPC_DeviceId deviceInterface, bool keepLock) {
	return OpenIPC_Error_Not_Implemented;
}

void BundleFilter::UpdateSettings(DeviceSettings *settings) {
	settingsPassedIn = true;

	// Pass settings to the next filter in the pipe
	if(nextFilter != nullptr) {
		nextFilter->UpdateSettings(settings);
	}
}

BundleFilter::~BundleFilter() {}

// TODO: Move to Fake
bool BundleFilter::ExecuteCalled() {
	return executed;
}
bool BundleFilter::SettingsCalled()
{
	return settingsPassedIn;
}
