
set(HeaderFiles_Headers "ProbePluginASD_JTAG.hpp"
						"InterfaceInstanceJtagASD.hpp"
						"InterfaceInstanceI2cASD.hpp"
						"JtagChainInfo.h"
						"JtagChainParameters.h"
						"Command.h"
						"PPI_InterfaceTriggerResponse.h"
						"Handle.h"
						"BundleHelpersASD.h"
						"ProbeInstanceASD.h"
						"InterfaceInstanceRemotePins.h"
						"OutputBuffers.h"
						"GotoStateOptions.h"
						"BundleFilter.h"
						"ToBMCFilter.h"
						"NOOPFilter.h"
)
set(SourceFiles_Sources "ProbePluginASD_JTAG.cpp"
						"BundleHelpersASD.cpp"
						"ProbeInstanceASD.cpp"
						"InterfaceInstanceRemotePins.cpp"
						"InterfaceInstanceJtagASD.cpp"
						"InterfaceInstanceI2cASD.cpp"
						"PPI_InterfaceTriggerResponse.cpp"
						"BundleFilter.cpp"
						"ToBMCFilter.cpp"
						"NOOPFilter.cpp"
)

#ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})

set(SOURCES ${SOURCES} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes} CMakeLists.txt)

ShipSources(FILES ${SOURCES} ${SourceFiles_Sources_Windows})

if(WIN32)
	configure_file(
	  ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
	  ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
	  @ONLY)

	set(ResourceFiles "./Generated/resource.rc")
	set(SOURCES ${SOURCES} ${ResourceFiles})
	source_group("Resource Files" FILES ${ResourceFiles})

	source_group("Source Files" FILES ${SourceFiles_Sources_Windows})
	set(SOURCES ${SOURCES} ${SourceFiles_Sources_Windows})
endif()
