#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include <Foundation/Error/ErrorTypes.h>
#include <Foundation/BitData/BitDataTypes.h>
#include <Foundation/Types.h>
#include <vector>

enum LoopStatus {
	RUNNING = 0,
	BREAK_NO_ERROR = 1,
	BREAK_ERROR = 2
};

class Command;

typedef struct Local_Handle {
	Command *start, *last, *enclosingContext;
	LoopStatus status;
	std::vector<BitData*> slots;
	BitData* last_data;
	uint64_t number_of_bits_in_last_data;
	uint32_t ir_pre, ir_post, dr_pre, dr_post;
	OpenIPC_DeviceId target;
	bool target_valid;
} Local_Handle;

class Command {
	// Note: much better to use non-manually managed memory structures here (or one needs to provide a destructor)
protected:
	Command* previous;
	Local_Handle* context;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting) = 0;

public:
	Command* next;
	virtual ~Command() {};
	virtual OpenIPC_Error Execute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, Command **next, bool doneExecuting);
	virtual OpenIPC_Error Append(Command* cmd);
	virtual OpenIPC_Error Clear();
	virtual uint32_t length_of_output() = 0;
	virtual void set_handle(Local_Handle* handle);
};
