//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "InterfaceInstanceI2cASD.hpp"
#include "RemoteConnection_Static.h"
#include "RemoteConnection.h"
#include "ProbePluginErrors.h"
#include "BundleHelpersASD.h"

InterfaceInstanceI2cASD::InterfaceInstanceI2cASD(uint32_t interface_refid, uint32_t instance_id, PPI_InterfaceI2CCapabilities caps) :
	InterfaceInstanceI2c(interface_refid, instance_id, caps),
	_eventHandlerFunction(nullptr)
{
	this->settings.busSelect = I2C_MIN_BUS_SELECT;
	this->settings.busSpeed = I2C_MAX_BUS_SPEED;
}

I2cConfiguration InterfaceInstanceI2cASD::GetSettings()
{
	return this->settings;
}

void InterfaceInstanceI2cASD::SetConfig(I2cConfiguration config)
{
	this->settings.busSelect = config.busSelect;
	this->settings.busSpeed = config.busSpeed;
}

OpenIPC_Error InterfaceInstanceI2cASD::Read(uint8_t deviceId, uint32_t bufferLength, uint8_t* readBuffer, PPI_bool forceStop, PPI_bool* addressAck)
{
	Connection_Error result = No_Error;
	GotoStateOptions i2c = GotoStateOptions();
	i2c.readParams.deviceId = deviceId;
	i2c.readParams.bufferLength = bufferLength;
	i2c.readParams.readBuffer = readBuffer;
	i2c.readParams.addressAck = addressAck;
	i2c.readParams.forceStop = forceStop;
	i2c.isI2cRead = true;

	result = RemoteShift(probe->deviceID, JtagNoStateChange, NULL, 0, (char*)readBuffer, bufferLength, &i2c);
	return To_OpenIPC_Error(result);
}

OpenIPC_Error InterfaceInstanceI2cASD::Write(uint8_t deviceId, uint32_t bufferLength, const uint8_t* writeBuffer, PPI_bool forceStop, PPI_bool* addressAck, uint32_t* lastDataAck)
{
	Connection_Error result = No_Error;
	GotoStateOptions i2c = GotoStateOptions();
	i2c.writeParams.deviceId = deviceId;
	i2c.writeParams.bufferLength = bufferLength;
	i2c.writeParams.writeBuffer = writeBuffer;
	i2c.writeParams.addressAck = addressAck;
	i2c.writeParams.forceStop = forceStop;
	i2c.writeParams.lastDataAck = lastDataAck;
	i2c.isI2cRead = false;

	result = RemoteShift(probe->deviceID, JtagNoStateChange, (char*)writeBuffer, bufferLength, NULL, 0, &i2c);
	return To_OpenIPC_Error(result);
}

OpenIPC_Error InterfaceInstanceI2cASD::InterfaceRegisterEventHandler(PluginEventCallbackHandler eventHandlerFunction)
{
	OpenIPC_Error openIPCError = OpenIPC_Error_No_Error;

	if (eventHandlerFunction == nullptr)
		return openIPCError;

	if (_eventHandlerFunction == nullptr)
	{
		_eventHandlerFunction = eventHandlerFunction;
	}
	else
	{
		openIPCError = OpenIPC_Error_Callback_Already_Initialized;
		PPI_ERROR(OpenIPC_INVALID_DEVICE_ID, openIPCError);
	}

	return openIPCError;
}
