#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////

#include "CProbePlugin.hpp"
#include <Foundation/Error/ErrorTypes.h>
#include "JtagChainParameters.h"
#include "GotoStateOptions.h"

#define I2C_MIN_BUS_SPEED 1
#define I2C_MAX_BUS_SPEED 400000
#define I2C_MIN_BUS_SELECT 0
#define I2C_MAX_BUS_SELECT 255
#define I2C_CMD_MASK 0xE0
#define I2C_READ_CMD 0x20
#define I2C_WRITE_CMD 0x60
#define I2C_WRITE_ACK_MASK 0x80
#define I2C_SIZE_MASK 0x0F
#define I2C_FORCE_STOP_BIT 0x10
#define I2C_CMD_SIZE 2
#define I2C_MAX_BUSES 20

class InterfaceInstanceI2cASD : public InterfaceInstanceI2c
{
public:
	InterfaceInstanceI2cASD(uint32_t interface_refid, uint32_t instance_id, PPI_InterfaceI2CCapabilities caps);

	virtual ~InterfaceInstanceI2cASD(){};
	I2cConfiguration GetSettings();
	void SetConfig(I2cConfiguration config);
	OpenIPC_Error Read(uint8_t deviceId, uint32_t bufferLength, uint8_t* readBuffer, PPI_bool forceStop, PPI_bool* addressAck);
	OpenIPC_Error Write(uint8_t deviceId, uint32_t bufferLength, const uint8_t* writeBuffer, PPI_bool forceStop, PPI_bool* addressAck, uint32_t* lastDataAck);
	virtual OpenIPC_Error InterfaceRegisterEventHandler(PluginEventCallbackHandler eventHandlerFunction);

private:
	I2cConfiguration settings;
	PluginEventCallbackHandler _eventHandlerFunction;
};
