#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////

#include "CProbePlugin.hpp"
#include <Foundation/Error/ErrorTypes.h>

#include "JtagChainInfo.h"
#include "JtagStateBasedOperations.h"
#include "JtagChainParameters.h"

const std::string JtagEncryptionProtocol = "Jtag.EncryptionProtocol";

class InterfaceInstanceJtagASD : public InterfaceInstance
{
public:
	bool					jtagActive;		// TBD: should this be generalized for all interface types?
	JtagStateEncode			lastjtagstate;	// the memory of the current TSM state of the JTAG chain
	PPI_InterfaceJTAGCapabilities	capabilities;			// a bit vector of capabilities supported (just set to zero for now)
	PluginEventCallbackHandler _eventHandlerFunction;
	InterfaceInstanceJtagASD(uint32_t interface_refid, uint32_t instance_id, PPI_InterfaceJTAGCapabilities caps, JtagChainInfo jtagSettingsIn);

	virtual ~InterfaceInstanceJtagASD(){};
	virtual void SettingsUpdated() override;
	virtual OpenIPC_Error GotoState(JtagStateEncode state, uint32_t count, const PPI_JTAG_StateGotoOptions* options);
	virtual OpenIPC_Error Shift(JtagStateEncode state, char *writeBuffer, size_t writeSize, char *readBuffer, size_t readSize);
	virtual OpenIPC_Error InterfaceRegisterEventHandler(PluginEventCallbackHandler eventHandlerFunction);
	int GetDeviceId();
	virtual void ObtainJtagChainParameters(JtagChainParameters *params);
	virtual void SetMultiBundleExecute(bool flag);
	virtual void SetMultiBundleFinalInterface(bool flag);
	virtual void SetSendWaitSync(bool flag);
	virtual OpenIPC_Error GetInterfacePadding(uint32_t* irPaddingNearTDI,
									 uint32_t* irPaddingNearTDO,
									 uint32_t* drPaddingNearTDI,
									 uint32_t* drPaddingNearTDO,
									 PPI_bool* drValueConstantOne);

	virtual OpenIPC_Error SetInterfacePadding(uint32_t irPaddingNearTDI,
									 uint32_t irPaddingNearTDO,
									 uint32_t drPaddingNearTDI,
									 uint32_t drPaddingNearTDO,
									 PPI_bool drValueConstantOne);
	virtual void SetEncryptionProtocol(uint32_t value);
	ASD_JTAG_PROTOCOL EncryptionProtocol(void);
protected:
	uint32_t irPaddingNearTDI, irPaddingNearTDO, drPaddingNearTDI, drPaddingNearTDO;
	PPI_bool drValueConstantOne;
	JtagChainInfo jtagSettings;
	uint32_t _encryptionProtocol;
};
