#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "JtagChainInfo.h"
#include "ProbeTypes.h"

typedef struct InterfacePadding {
	uint32_t irPaddingNearTDI;
	uint32_t irPaddingNearTDO;
	uint32_t drPaddingNearTDI;
	uint32_t drPaddingNearTDO;
} InterfacePadding;

enum JTAG_DRIVER_MODE
{
	JTAG_DRIVER_MODE_SOFTWARE = 0,
	JTAG_DRIVER_MODE_HARDWARE = 1
};

enum JTAG_CHAIN_SELECT_MODE
{
	JTAG_CHAIN_SELECT_MODE_SINGLE = 0,
	JTAG_CHAIN_SELECT_MODE_MULTI = 1
};

#define DEFAULT_JTAG_SYNC_TIMEOUT_VALUE 5000
#define DEFAULT_JTAG_SYNC_DELAY_VALUE 1000

typedef struct JtagChainParameters
{
	InterfacePadding *InterfacePaddingSettings;
	JtagChainInfo *JtagChainSettings;
	enum JTAG_CHAIN_SELECT_MODE JtagChainSelectMode;
	enum JTAG_DRIVER_MODE JtagDriverMode;
	uint16_t JtagSyncTimeoutValue;
	uint16_t JtagSyncDelayValue;
} JtagChainParameters;

typedef struct I2cConfiguration {
	uint32_t busSelect;
	uint32_t busSpeed;
} I2cConfiguration;

typedef struct I2cReadParams {
	uint8_t deviceId;
	uint32_t bufferLength;
	uint8_t* readBuffer;
	PPI_bool forceStop;
	PPI_bool* addressAck;
} I2cReadParams;

typedef struct I2cWriteParams {
	uint8_t deviceId;
	uint32_t bufferLength;
	const uint8_t* writeBuffer;
	PPI_bool forceStop;
	PPI_bool* addressAck;
	uint32_t* lastDataAck;
} I2cWriteParams;

// nonstandard extension used: nameless struct/union
#pragma pack(push,1)
union LoggingConfiguration {
	struct Parsed {
		uint8_t logging_level : 3;
		uint8_t logging_stream : 3;
	} Parsed;
	char value;
};
#pragma pack(pop)
