#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////


#include "Public/StructuredData.h"					// For XML support

#include "InterfaceInstanceJtagASD.hpp"
#include "InterfaceInstanceI2cASD.hpp"
#include "InterfaceInstanceRemotePins.h"
#include "OutputBuffers.h"
#include "JtagChainParameters.h"
#include "ConnectionParameters.h"

#define CMD_WAITCYCLES 0x10
#define CMD_WRITECFG_JTAG_FREQ 0x1
#define READ_CMD_MASK 0xF

#define LEFT false
#define RIGHT true

class ProbeInstanceASD : public ProbeInstance, std::enable_shared_from_this<ProbeInstanceASD>
{
public:
	ProbeInstanceASD(uint32_t probe_refid, std::string typestring, uint32_t typid = 0);
	OpenIPC_Error GetDrivablePins(std::vector<PPI_Pins_TypeEncode>& pins) const;
	OpenIPC_Error GetReadablePins(std::vector<PPI_Pins_TypeEncode>& pins) const;
	virtual OpenIPC_Error SetPinsInterface(std::shared_ptr<InterfaceInstanceRemotePins> probeinterface);
	virtual OpenIPC_Error ProbeRegisterEventHandler(PluginEventCallbackHandler eventHandlerFunction);
	virtual void callEventHandler(PPI_PluginEvent pluginEvent, uint64_t value);
	OpenIPC_Error ConfigureTap(JtagChainParameters* params);
	OpenIPC_Error DelayUseconds(uint32_t numberOfUseconds);
	virtual bool ProcessSpecialCommands(char command, std::shared_ptr<OutputBuffers> buffer, char data, uint16_t *size);
	virtual ~ProbeInstanceASD() {};
	virtual void SettingsUpdated() override;
	virtual void AppendDownstreamVersion(char *buffer, uint16_t length);
	virtual void SetVersion();
	virtual std::string GetVersion();
	double clockCycleTimeinUs;
	static void MajorMinor(const char *in, unsigned int length, char *out, bool right);
	uint32_t GetNextJtagInterfaceId();
	std::shared_ptr<InterfaceInstanceJtagASD> GetJtagInterface(uint32_t jtagProtocolId);
	OpenIPC_Error AddJtagInterface(std::shared_ptr<InterfaceInstanceJtagASD> jtagInterface);
	void JtagDeinitialize();
	uint32_t GetI2cInterfaceBusCount();
	OpenIPC_Error AddI2CInterface(std::shared_ptr<InterfaceInstanceI2cASD> i2cInterface);
	void I2CDeinitialize();
	OpenIPC_Error ProbeInitializeConnectionParams(DataElement* probeChild, int &cnt);
	OpenIPC_Error ProbeInitializePins(std::shared_ptr<InterfaceInstanceRemotePins> &pinInterface, DataElement* probeChild, int &cnt);
	OpenIPC_Error ProbeInitializeI2C(DataElement* probeChild, int &cnt);
	OpenIPC_Error ProbeInitializeJtag(DataElement* probeChild, int &cnt);
	OpenIPC_Error ProbeInitializeJtagDevHandle(DataElement* probeChild, int &cnt, std::shared_ptr<ConnectionParameters> connectionParameters);
	OpenIPC_Error ProbeInitializeHwConfig(DataElement* probeChild, uint8_t &hardware_gpio_config, JtagChainParameters *params);
	std::string CheckAttributeValue(DataElement* probeChild, std::string attribName, std::string defaultValue);
	std::string SocketServerMajorMinor;
	std::string ProbeMajorMinor;
	std::string UniqueId;
	std::shared_ptr<ConnectionParameters> connectionParameters;
	std::shared_ptr<ProbeInstanceASD> this_shared;
protected:
	std::string fwVersion;
	std::string socketServerVersion;
	std::shared_ptr<InterfaceInstanceRemotePins> pinInterface;
	std::vector<std::shared_ptr<InterfaceInstanceJtagASD>> jtagInterfaces;  // weak ptrs are used in AddInterface, so we need to store a copy too
	std::vector<std::shared_ptr<InterfaceInstanceI2cASD>> i2cInterfaces;  // weak ptrs are used in AddInterface, so we need to store a copy too
	PluginEventCallbackHandler _eventHandlerFunction;
private:
	void PrintNotification(uint32_t type, std::string msg);
	bool IsParamValid(std::vector<std::string> param_list, std::string param);
	bool IsParamInRange(int min, int max, int param);
	static OpenIPC_Error DetermineProtocolPrescaleAndDivisor(uint16_t& value, uint8_t& pre, uint8_t& div);
};
