#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////

/*
	if DAL support is needed this has to be uncommented
*/
#define USE_INTERFACE_SCAN 1

#include "CProbePlugin.hpp"
#include "JtagStateBasedOperations.h"
#include <map>

#include "ProbeInstanceASD.h"
#include "GotoStateOptions.h"
#include "OutputBuffers.h"
#include "BundleFilter.h"

#include "I2CDirectOperations.h"
#include <ConnectionParameters.h>

#define FPGA_BASE_FREQ 50000000
#define READ_CMD_BIT 0x8
#define CFGREG_PIN_STATUS 0x1
#define READ_CMD_MASK 0xF
#define WAIT_CYCLES_LOG 0x10

#define STATE_CHANGE_BYTE 0x20
#define CMD_WAITCYCLES 0x10
#define WRITE_SCAN 0x40
#define READ_SCAN 0x80
#define RW_SCAN 0xC0
#define MAX_RW_SCAN_SIZE 8
#define TARGET_RESET 0x1

#define WAIT_TIME "1000" //we will wait for the server to respond for 1s
#define DEFAULT_PORT "5123"
#define DEFAULT_IP_ADDR "127.0.0.1"

#define PROBE_PLUGIN_VERSION "dev-"

#define DEFAULT_JTAG_PRESCALER 2
#define DEFAULT_JTAG_DIVISOR 5

// these are the string representations of the TAP states corresponding to the enums literals in JtagStateEncodeASD
const char* const c_statestrASD[] = { "TLR", "RTI", "SelDR", "CapDR", "ShfDR", "Ex1DR", "PauDR", "Ex2DR", "UpdDR", "SelIR", "CapIR", "ShfIR", "Ex1IR", "PauIR", "Ex2IR", "UpdIR", "NoSC", "0x11" };

class ProbePluginASD_JTAG : public CProbePlugin
{
public:
	static ProbePluginASD_JTAG* GetInstance(ProbePluginASD_JTAG *instance_override = nullptr);

	virtual OpenIPC_Error InterfaceGetInfoJTAG(OpenIPC_DeviceId probeID, PPI_RefId interface_refid, PPI_InterfaceJTAGCapabilities* capabilities) override;
	virtual OpenIPC_Error PluginRegisterEventHandler(PluginEventCallbackHandler eventHandlerFunction) override;
	virtual OpenIPC_Error PluginSetLogEventHandler(PluginLogCallbackHandler logHandlerFunction) override;
	virtual OpenIPC_Error PPI_PluginSetStreamLogEventHandler(PluginStreamLogCallbackHandler logCallBackFunction) override;
	virtual OpenIPC_Error PluginRegisterNotificationHandler(PluginNotificationCallbackHandler notificationHandlerFunction) override;
	virtual OpenIPC_Error PluginSetNotificationRequiredForNotificationCallBack(PPI_NotificationLevel severity) override;
	virtual OpenIPC_Error PPI_PluginSetNotificationRequiredForStreamLogCallBack(PPI_Stream stream, PPI_NotificationLevel level) override;
	virtual OpenIPC_Error InterfaceOperationCancel(OpenIPC_DeviceId interfaceID) override;
	virtual OpenIPC_Error LockTargetInterface(OpenIPC_DeviceId deviceInterface) override;
	virtual PPI_ProbeBundleHandle BundleAllocate() override;
	virtual OpenIPC_Error BundleExecute(PPI_ProbeBundleHandle handle, OpenIPC_DeviceId deviceInterface, PPI_bool keepLock) override;
	virtual OpenIPC_Error BundleExecuteMultiChain(PPI_ProbeBundleHandle handle, OpenIPC_DeviceId* deviceInterfaces, uint32_t deviceInterfacesLength, PPI_bool keepLock) override;
	virtual OpenIPC_Error BundleClear(PPI_ProbeBundleHandle handle) override;
	virtual OpenIPC_Error BundleFree(PPI_ProbeBundleHandle* handle) override;
	virtual OpenIPC_Error PPI_JTAG_GoToState(PPI_ProbeBundleHandle handle, JtagStateEncode gotoState, uint32_t numberOfClocksInState, const PPI_JTAG_StateGotoOptions* const options) override;
	virtual OpenIPC_Error PPI_JTAG_StateIRShift(PPI_ProbeBundleHandle handle, uint32_t shiftLengthBits, const uint8_t* const inBits, uint8_t* outBits, const PPI_JTAG_StateShiftOptions* const options) override;
	virtual OpenIPC_Error PPI_JTAG_StateDRShift(PPI_ProbeBundleHandle handle, uint32_t shiftLengthBits, const uint8_t* const inBits, uint8_t* outBits, const PPI_JTAG_StateShiftOptions* const options) override;
	virtual OpenIPC_Error _GetDrivablePins(std::vector<PPI_Pins_TypeEncode>& pins) const override;
	virtual OpenIPC_Error _GetReadablePins(std::vector<PPI_Pins_TypeEncode>& pinAliases) const override;
	virtual std::shared_ptr<InterfaceInstance> InterfaceFromId(OpenIPC_DeviceId interfaceID);
	virtual OpenIPC_Error GetInterfaceJTAGPadding(OpenIPC_DeviceId device,
		uint32_t* irPaddingNearTDI,
		uint32_t* irPaddingNearTDO,
		uint32_t* drPaddingNearTDI,
		uint32_t* drPaddingNearTDO,
		PPI_bool* drValueConstantOne
	) override;
	virtual OpenIPC_Error SetInterfaceJTAGPadding(OpenIPC_DeviceId device,
		uint32_t irPaddingNearTDI,
		uint32_t irPaddingNearTDO,
		uint32_t drPaddingNearTDI,
		uint32_t drPaddingNearTDO,
		PPI_bool drValueConstantOne
	) override;
	virtual OpenIPC_Error PPI_JTAG_GetCurrentBundlePadding(PPI_ProbeBundleHandle bundle,
		int32_t* irPaddingNearTDI,
		int32_t* irPaddingNearTDO,
		int32_t* drPaddingNearTDI,
		int32_t* drPaddingNearTDO,
		PPI_bool* drValueConstantOne
	) override;
	virtual OpenIPC_Error PPI_JTAG_UpdateBundlePadding(PPI_ProbeBundleHandle bundle,
		int32_t irPaddingNearTDI,
		int32_t irPaddingNearTDO,
		int32_t drPaddingNearTDI,
		int32_t drPaddingNearTDO,
		PPI_bool drValueConstantOne
	) override;
	virtual OpenIPC_Error ProbeGetInfo(PPI_RefId refId, PPI_ProbeInfo* info) override;
	void SetProbeId(std::shared_ptr<ProbeInstanceASD> probe, OpenIPC_DeviceId probeID);
	virtual OpenIPC_Error ListProbes(uint32_t maxNumberOfProbes, OpenIPC_DeviceId *probes, uint32_t *numberOfProbes);
	virtual OpenIPC_Error ListInterfaces(uint32_t maxNumberOfInterfaces, OpenIPC_DeviceId *interfaces, uint32_t *numberOfInterfaces);
	virtual OpenIPC_Error RegisterBundleFilter(ASD_JTAG_PROTOCOL protocol, std::shared_ptr<BundleFilter> filter);
	virtual OpenIPC_Error DeRegisterAllBundleFilters(void);
	virtual std::shared_ptr<BundleFilter> GetBundleFilter(ASD_JTAG_PROTOCOL protocol);
	virtual OpenIPC_Error PluginInitialize(PPI_RefId pluginid, const char* vendorinit) override;
	OpenIPC_Error LookupProbe(OpenIPC_DeviceId probeID, std::shared_ptr<ProbeInstanceASD>& probeInstance);
	std::map<ASD_JTAG_PROTOCOL, std::shared_ptr<BundleFilter>> &BundleFilters();
	ProbePluginASD_JTAG();
protected:
	std::vector<std::shared_ptr<ProbeInstanceASD>> _probes;  // we need to store a copy of the probes because CProbePlugin stores them as weak pointers
#ifdef USE_INTERFACE_SCAN
	std::map<OpenIPC_DeviceId, bool> keepLocks;

	virtual OpenIPC_Error _JtagScan(InterfaceInstance& interfaceInstance, const uint32_t* input, uint32_t inputdwords, uint32_t* output, uint32_t maxoutputdwords, uint32_t* outputdwords) override;
	virtual OpenIPC_Error _I2cScan(InterfaceInstance& interfaceInstance, const uint32_t* input, uint32_t inputdwords, uint32_t* output, uint32_t maxoutputdwords, uint32_t* outputdwords) override;
	virtual OpenIPC_Error _PinsScan(InterfaceInstance& interfaceInstance, const uint32_t* input, uint32_t inputdwords, uint32_t* output, uint32_t maxoutputdwords, uint32_t* outputdwords) override;
#endif
	std::map<ASD_JTAG_PROTOCOL, std::shared_ptr<BundleFilter>> protocolFilters;

	virtual OpenIPC_Error _GetProbes(std::vector<std::weak_ptr<ProbeInstance>>& probes, const char* vendorinit) override; // this is called during PlugIn init to get the initial enumeration of probes
	virtual OpenIPC_Error _GetProbeInterfaces(std::shared_ptr<ProbeInstance> probe, std::vector<std::weak_ptr<InterfaceInstance>>& probeinterfaces) override; // this is called during probe init to get the initial enumeration of interfaces override; // this is called during probe init to get the initial enumeration of interfaces

	virtual OpenIPC_Error ProbeInitialize(uint32_t probe_refid, OpenIPC_DeviceId probeID, const char* vendorinit) override;
	virtual OpenIPC_Error ProbeDeInitialize(OpenIPC_DeviceId probeID) override;

	virtual OpenIPC_Error InterfacePortRead(OpenIPC_DeviceId interfaceID, uint8_t* output, uint32_t maxoutputbytes, uint32_t* outputbytes) override;
	virtual OpenIPC_Error InterfacePortOpenWindow(OpenIPC_DeviceId interfaceID, PPI_Trace_PortAccessMode accessMode) override;
	virtual OpenIPC_Error InterfacePortCloseWindow(OpenIPC_DeviceId interfaceID) override;
	virtual OpenIPC_Error InterfacePortIsReadDataAvailable(OpenIPC_DeviceId interfaceID, bool* isDataAvailable)override;
	virtual OpenIPC_Error InterfacePortIsWindowOpen(OpenIPC_DeviceId interfaceID, bool* isWindowOpen)override;
private:
	std::shared_ptr<ProbeInstanceASD> XmlToProbeInstance(DataElement* element, uint32_t probe_idx);
};
