/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"

#include <cstring>

namespace CommonUtils
{
    /*!
    \brief wrapper for memcpy to achieve SDL compliance

    This function is a thin wrapper around memcpy that is used to select the correct implementation
    on a per-platform basis,to conform to SDL requirements
    */
    void MemoryCopy(void* dest, size_t destsz, const void* src, size_t count)
    {
        if (dest != nullptr && src != nullptr && destsz != 0 && count != 0)
        {
            const size_t sizeToCopy = std::min(destsz, count);
            const uint8_t* const byteSource = reinterpret_cast<uint8_t const*>(src);
            uint8_t* const byteDest = reinterpret_cast<uint8_t *>(dest);
            std::copy(byteSource, byteSource + sizeToCopy, byteDest);
        }
    }

}
