/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include <regex>
#include <stdint.h>
#include <ostream>

class Frequency
{
    uint64_t _hertz;

public:
    Frequency();

    explicit Frequency(uint64_t hertz);

    // Frequency format = (\d+(?:\.\d+)?)([GMk]?Hz)?
    // Note: Will be rounded to the nearest Hz
    explicit Frequency(std::string frequency);

    uint64_t GetHertz() const;

    static bool IsFrequency(std::string frequency);

    friend bool operator==(const Frequency& lhs, const Frequency& rhs);
    friend bool operator!=(const Frequency& lhs, const Frequency& rhs);
    friend bool operator<(const Frequency& lhs, const Frequency& rhs);
    friend bool operator<=(const Frequency& lhs, const Frequency& rhs);
    friend bool operator>(const Frequency& lhs, const Frequency& rhs);
    friend bool operator>=(const Frequency& lhs, const Frequency& rhs);
    friend std::ostream& operator<<(std::ostream& os, const Frequency& obj);
};
