/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

namespace CommonUtils
{
    void MemoryCopy(void* dest, size_t destsz, const void* src, size_t count  );

    template<size_t N, class T>
    void MemoryCopy(T(&dest)[N], const void* src, size_t count)
    {
        MemoryCopy(dest, sizeof(dest), src, count);
    }

    template<class T, class U>
    void MemoryCopy(std::vector<T> &dest, const std::vector<U> &src)
    {
        CommonUtils::MemoryCopy(dest.data(), dest.size() * sizeof(T), src.data(), src.size() * sizeof(U));
    }

    template<size_t N, class T>
    void MemoryCopyOffset(T(&dest)[N], size_t byteOffset, const void* src, size_t count)
    {
        MemoryCopy(reinterpret_cast<uint8_t*>(dest) + byteOffset, sizeof(dest) - byteOffset, src, count);
    }


}
