set(Public_Include_Headers "${OPENIPC_ROOT}/Source/Public_Include/Foundation/Error/Error.h"
                           "${OPENIPC_ROOT}/Source/Public_Include/Foundation/Error/ErrorMacros.h"
                           "${OPENIPC_ROOT}/Source/Public_Include/Foundation/Error/ErrorTypes.h"
                           "${OPENIPC_ROOT}/Source/Public_Include/Foundation/Error/OpenIPC_ErrorContext.h")

set(HeaderFiles_Headers "ErrorContextImpl.h"
                        "stdafx.h")

set(SourceFiles_Sources "ErrorContextImpl.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Public_Include" FILES ${Public_Include_Headers})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})

# Store all sources in SOURCES variable
set(SOURCES ${SOURCES} ${Public_Include_Headers} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes})

ShipSources(FILES ${SOURCES} CMakeLists.txt)

if(WIN32)
    configure_file(
	  ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
	  ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
	  @ONLY)

    set(ResourceFiles "./Generated/resource.rc")
    set(SOURCES ${SOURCES} ${ResourceFiles})
    source_group("Resource Files" FILES ${ResourceFiles})
endif()
