
set(Public_Include_Headers "../../Public_Include/Foundation/IndexList/IndexList.h"
                           "../../Public_Include/Foundation/IndexList/IndexListTypes.h"
                           "../../Public_Include/Foundation/IndexList/OpenIPC_IndexList.h")
set(HeaderFiles_Headers "stdafx.h")

set(PrebuildScript_Others "createdefifnewer.py")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Public_Include" FILES ${Public_Include_Headers})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})
source_group("Prebuild Script" FILES ${PrebuildScript_Others})

set(SOURCES ${SOURCES} ${Public_Include_Headers} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes} ${PrebuildScript_Others})

ShipSources(FILES ${SOURCES} CMakeLists.txt)

if(WIN32)
    configure_file(
      ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
      ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
      @ONLY)

    set(ResourceFiles "./Generated/resource.rc")
    source_group("Resource Files" FILES ${ResourceFiles})
    set(SOURCES ${SOURCES} ${ResourceFiles})

    set(PrebuildScript_Output "${CMAKE_CURRENT_BINARY_DIR}/IndexList.def")

    set(SOURCES ${SOURCES} ${PrebuildScript_Output})
endif()
