﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include <Foundation/Logging/Logging.h>

#include <PushNewOverride.h>
#include <boost/log/core.hpp>
#include <boost/log/sources/severity_channel_logger.hpp>
#include <boost/log/sources/record_ostream.hpp>
#include <boost/log/attributes/mutable_constant.hpp>

#include <PopNewOverride.h>

#include <atomic>
#include <mutex>
#include <vector>
#include <tuple>

class OpenIPCLogger
{
private:
	OpenIPC_LoggingLoggerId _loggerId;
	std::atomic<std::size_t> _loggerLevel; // Use an atomic so that we dont have issues between threads.
    std::string _name;

	// Listener is a combination of a void* (to store a this pointer) and two callback methods
    std::vector<std::tuple<void*, OpenIPC_LoggingReceiveMessageCallback, OpenIPC_LoggingSeverityLevelChangedCallback>> _listeners;
    std::timed_mutex _listenersMutex;

	std::vector<std::string> _sinkTargets;
	boost::log::attributes::mutable_constant<std::vector<std::string>> _sinkTargetsAttribute;

public:
	boost::log::sources::severity_channel_logger_mt<OpenIPC_LoggingSeverityLevel> _boostLogger;

	OpenIPCLogger(OpenIPC_LoggingLoggerId id, std::string name, OpenIPC_LoggingSeverityLevel loggerLevel);

    const std::string& GetName() const
    {
        return _name;
    }

    void Log(OpenIPC_LoggingSeverityLevel severity, const std::string& message, int indent = 0);

	bool IsLogEnabled(OpenIPC_LoggingSeverityLevel severity)
	{
		return static_cast<std::size_t>(severity) >= _loggerLevel;
	}

	OpenIPC_LoggingSeverityLevel GetLogSeverityLevel()
	{
		std::size_t level = _loggerLevel;
		return static_cast<OpenIPC_LoggingSeverityLevel>(level);
	}

	void SetLogSeverityLevel(OpenIPC_LoggingSeverityLevel value);

	const std::vector<std::string>& GetSinkTargets()
	{
		return _sinkTargets;
	}

	void SetSinkTargets(const std::vector<std::string>& sinkTarget);

    OpenIPC_LoggingLoggerId GetId() const
    {
        return _loggerId;
    }

    void AddListener(void* data, OpenIPC_LoggingReceiveMessageCallback receiveMessage, OpenIPC_LoggingSeverityLevelChangedCallback severityLevelChanged);
    void RemoveListener(void* data, OpenIPC_LoggingReceiveMessageCallback receiveMessage, OpenIPC_LoggingSeverityLevelChangedCallback severityLevelChanged);
};
